/*
  mt_Address.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "insist.h"
#include "mt_Address.h"
#include "mt_Component.h"

char mt_Address::buffer [NUM_BYTES * 3];

mt_Address::mt_Address ()
{
  memset (bytes, 0, NUM_BYTES);
}

mt_Address::mt_Address (char*_bytes)
{
  memcpy (this->bytes, _bytes, NUM_BYTES);
}

void mt_Address::fromBytes (char*bytes)
{
 memcpy (this->bytes, bytes, NUM_BYTES);  
}
void mt_Address::copyOut (char*s)
{
  for (int i = 0; i < NUM_BYTES; i++)
    s[i] = bytes [i];
}
  
void mt_Address::set (int n)
{
  for (int i = 0; i < NUM_BYTES; i++, n = n >> 8)
    bytes [i] = n & 0xff;
}

char*mt_Address::toString (char*s)
{
  if (!s)
    s = buffer;
  
  char*t=s;
  int i;
  
  for (i = 0; i < NUM_BYTES; i++)
    t+=sprintf (t,"%2.2x",(unsigned)bytes[i] & 0xff);
  return s;   
}

char*mt_Address::getBytes ()
{
  return bytes;
}

int mt_Address::compare (mt_Address*a)
{
  int i;

  insistf (this && a);
  
  for (i = 0; i < NUM_BYTES; i++)
    if (bytes [i] > a->bytes[i])
      return 1;
    else if (bytes [i] < a->bytes [i])
      return -1;
  exception: return 0;
}

int mt_Address::fromString (char*s)
{
  if (!s || !*s)
    return 0;

  char t[3];
  t[2] = 0;
    
  int i;
  for (i = 0; *s && i < NUM_BYTES; i++)
  {
    t[0] = *s++;
    t[1] = *s ?  *s++ : 0;
      
    unsigned n;
    sscanf (t,"%x",&n);
    bytes[i] = n & 0xff;
  }
  for (; i < NUM_BYTES; i++)
    bytes[i] = 0;

  return 1;
}

int mt_Address::isZero ()
{
  for (int i = 0; i < NUM_BYTES; i++)
    if (bytes [i])
      return 0;
  return 1;
}
