#ifndef insist_h
#define insist_h

#if defined (INSIST) || defined (EXPENSIVE_CHECKS)
#ifdef MT_ABORT
#include <stdlib.h>
#define mt_abort() abort()
#else
#define mt_abort()
#endif

#define insist(e) do { if (!(e) || !validComponent()) {printInsist ("assertion failed. %s:%d (%s)", __FILE__,__LINE__, #e); mt_abort();goto exception;}} while (0)
#define insistf(e) do { if (!(e)) {mt_Component::printInsist ("assertion failed. %s:%d (%s)", __FILE__,__LINE__, #e); mt_abort();goto exception;}} while (0)
#ifdef EXPENSIVE_CHECKS
#define insistx(e) do { if (!(e)) {mt_Component::printInsist ("assertion failed. %s:%d (%s)", __FILE__,__LINE__, #e); mt_abort();goto exception;}} while (0)
#else
#define insistx(e) do {if (0) goto exception;} while (0);
#endif
#define insistp(e, s) do { if (!(e)) {printInsist s; mt_abort();goto exception;}} while (0)

#else
#define insist(e) do {if (0) goto exception;} while (0);
#define insistf(e) do {if (0) goto exception;} while (0);
#define insistx(e) do {if (0) goto exception;} while (0);
#define insistp(e, s) do {if (0) goto exception;} while (0);
#endif

#ifdef PERR
#define perr printFormat
#else
#define perr if(0) printFormat
#endif

#endif /*insist_h*/
