/*
  gr_Simulation.h
  griddle
  finucane@myri.com (David Finucane)
*/

#ifndef gr_Simulation_h
#define gr_Simulation_h

#include <stdio.h>

#include "mt_Simulation.h"
#include "mt_Job.h"
#include "mt_Network.h"
#include "mt_Queue.h"

class gr_Simulation;

class gr_Job: public mt_Job
{
  public:
  enum
  {
    LEFT = 0,
    RIGHT = 1,
    UP = 2,
    DOWN = 3,
    NUM_POSITIONS = 4,
    DATA = 0,
    HOTSPOT = 1,
    NUM_TYPES = 2
  };
  private:
  gr_Simulation *simulation;
  int numSends;
  int numReceives;
  int cycle;
  int x;
  int y;
  int z;
  double temperature;
  double temperatures [NUM_POSITIONS];
  int receives [NUM_POSITIONS];

  public:
  int typeSends [NUM_TYPES];
  int typeReceives [NUM_TYPES];
  
  private:
  int side;
  
  int isEdgeNode (int x, int y, int z);
  void compute ();
  void forget ();
  int ready ();
  int getPosition (int nx, int ny, int nz);
  int send ();
  int shouldSend (int position);
  int send (int position);
  int send (mt_Node*host);
  int getIndex (int x, int y, int z);
  int getNeighbor (int position, int*x, int*y, int*z);
  mt_Node*getHotHost ();
  void wait ();
  
  public:
  gr_Job (mt_Node*node, mt_Network*network, gr_Simulation*simulation);
  virtual ~gr_Job ();
  double getTemperature ();
  
  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};


class gr_Simulation: public mt_Simulation
{
  private:
  int side;
  double top, bottom, right, left;
  int packetLength;
  int period;
  int mod;

  public:
  
  gr_Simulation();
  virtual mt_Job*newJob (mt_Node*node, mt_Network*network, mt_Calculator*calc);
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);

  virtual void simpleDump (mt_Network*network, FILE *fp);

  int getPeriod ();
  int getMod ();
  int getSide ();
  int getPacketLength ();
  int getMaxSendsPending ();
  
  double getStartTemperature (int x, int y, int z);
};


#endif /*gr_Simulation_h*/
