/*
  f_Switch.h
  brute force route calculator
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef f_Switch_h
#define f_Switch_h

#include "f_Node.h"

class f_Switch : public f_Node
{
  public:
  enum
  {
    NUM_PORTS = 16
  };

  int found;

  int edgeIndex [NUM_PORTS];
  
  private:
  mt_Node*nodes [NUM_PORTS];
  char opposites [NUM_PORTS];

  public:
  f_Switch (char*name, char*type);
  
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void disconnect (int p);
  virtual int setOption (char*option, char*value);
};

#endif /*f_Switch_h*/
