/*
  f_Switch.c
  brute force route calculator
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"
#include "f_Switch.h"

f_Switch::f_Switch (char*name, char*type) : f_Node (name, type)
{
  for (int i = 0; i < NUM_PORTS; i++)
  {
    nodes [i] = 0;
    opposites [i] = -1;
    edgeIndex [i] = -1;
  }
}

int f_Switch::getNodeType ()
{
  return mt_Node::SWITCH;
}

int f_Switch::getMaxNodes ()
{
  return NUM_PORTS;
}

int f_Switch::setOption (char*option, char*value)
{
  return f_Node::setOption(option,value);
}

void f_Switch::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = n;
  opposites [p] = o;
  
  exception: return;
}

void f_Switch::disconnect (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  
  nodes [p] = 0;
  opposites [p] = -1;
  
  exception: return;
}

mt_Node*f_Switch::getNode (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return nodes [p];
  exception: return 0;
}


int f_Switch::getOpposite (int p)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  return opposites [p];
  exception: return -1;
}
