/*
  f_Calculator.h
  brute force route calculator
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef f_Calculator_h
#define f_Calculator_h

#include "mt_Route.h"
#include "mt_Calculator.h"
#include "f_Node.h"
#include "f_Switch.h"
#include "f_Host.h"
#include "f_Edge.h"

class f_Calculator : public mt_Calculator
{
  private:
  
  mt_Route ****routes;

  int calculateRoutes();
  int findRoute(int src, int dst);
  int explore(int src, int dst, char *bytes, int inPort,
	      int len, int maxDepth, f_Node *n);
  int checkForLoops(int src, int dst, char *bytes, int len);
  
  int numEdges;
  f_Edge *edge;

  public:
  f_Calculator();
  ~f_Calculator();

  virtual void cleanup ();
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);
  virtual int initialize (mt_Graph*graph, mt_Node*root);
  virtual int initialize (char *mapFile);
  virtual int getRoute (int from, int to, int routeIndex, mt_Route*route);
  virtual int getMaxRoutes ();
  virtual int getNumRoutes (int from, int to);
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
};

#endif /*f_Calculator_h*/
