/*
  dj_QElement.h
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef dj_QElement_h
#define dj_QElement_h

class dj_Switch;

class dj_QElement
{
  public:
  int qIndex;

  int sameSubnet;
  int dist;
  int hops;
  int time;

  int type;

  int inPort;
  dj_QElement *parent;

  dj_Switch *sw;

  // ------------------------

  int operator<(const dj_QElement &right)
  {
    if (hops!=right.hops)
      return (hops<right.hops);
    if (sameSubnet != right.sameSubnet)
      return sameSubnet;
    /*
    if (type != right.type)
      return (type<right.type);
    */
    if (dist!=right.dist)
      return (dist<right.dist);
    if (time!=right.time)
      return (time<right.time);
    return 0;
  }

  int operator>(const dj_QElement &right)
  {
    if (hops!=right.hops)
      return (hops>right.hops);
    if (sameSubnet != right.sameSubnet)
      return !sameSubnet;
    if (type != right.type)
      return (type<right.type);
    if (dist!=right.dist)
      return (dist>right.dist);
    if (time!=right.time)
      return (time>right.time);
    return 0;
  }

  int operator==(const dj_QElement &right)
  {
    if (sameSubnet == right.sameSubnet && hops==right.hops && dist==right.dist && time==right.time)
      return 1;
    return 0;
  }
};

#endif
