/*
  dj_Host.c
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#include <stdio.h>

#include "insist.h"
#include "dj_Host.h"



int dj_Host::getNodeType ()
{
  return mt_Node::HOST;
}

int dj_Host::getMaxNodes ()
{
  return 1;
}

dj_Host::dj_Host (char*name, char*type) : dj_Node (name, type)
{
  node = 0;
  opposite = -1;
}

void dj_Host::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (!p);

  node = n;
  opposite = o;
  
  exception: return;
}

void dj_Host::disconnect (int p)
{
  insist (this);
  insist (!p);

  node = 0;
  opposite = -1;
  
  exception: return;
}

mt_Node*dj_Host::getNode (int p)
{
  insist (this);
  insist (!p);
  return node;
  exception: return 0;
}

int dj_Host::getOpposite (int p)
{
  insist (this);
  insist (!p);
  return opposite;
  exception: return -1;
}
