/*
  dj_Calculator.h
  route calculator that uses Dijkstra's shortest path algorithm
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef dj_Calculator_h
#define dj_Calculator_h

#include "mt_Route.h"
#include "mt_Calculator.h"
#include "dj_Node.h"
#include "dj_Switch.h"
#include "dj_Host.h"

class dj_Calculator : public mt_Calculator
{
    
  private:
  enum
  {
    INFINITY = 2000000000
  };

  int numRoots;
  char **roots;
  dj_QElement **queue; // implemented as array-based min-heap
  int queueSize;
  int queueTime;
  int discoverCount;
  mt_Route ****routes;

  int useEdgeNumbers;
  int autoNumberFlag;
  int split;

  int subnet;
  
  int calculateRoutes();
  int calculateRoutesFrom(int srcHost);

  int initQueue(int srcHost);
  void deleteQueue();

  int followRoute(dj_Host *src, mt_Route *route);

  void swap(int index1, int index2);
  void trickle_up(int index);
  void trickle_down(int index);
  dj_QElement *extractMin();
  dj_QElement *getNBor(dj_QElement *from, int portNum);
  void discover(dj_QElement *s);

  int renumber (mt_Node*root);
  int checkNodeNumbers ();
  
  public:
  dj_Calculator();
  ~dj_Calculator();

  virtual void cleanup ();
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);
  virtual int initialize (mt_Graph*graph, mt_Node*root);
  virtual int initialize (char *mapFile);
  virtual int getRoute (int from, int to, int routeIndex, mt_Route*route);
  virtual int getMaxRoutes ();
  virtual int getNumRoutes (int from, int to);
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
};

#endif /*dj_Calculator_h*/
