/*
  de_Deadlock.h
  deadlock detector
  finucane@myri.com (David Finucane)
*/

#ifndef de_Deadlock_h
#define de_Deadlock_h

#include "mt_Component.h"
#include "mt_Switch.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Follower.h"

class de_Port;

class de_Edge : public mt_Component
{
  private:
  de_Port*from;
  de_Port*to;
  
  public:
  de_Edge ();
  int connect (de_Port*from, de_Port*to);
  int connected ();
  de_Port*getTo ();
  de_Port*getFrom ();  
};

class de_Port : public mt_Component
{
  public:

  enum
  {
    NUM_EDGES = mt_Switch::NUM_PORTS,
    CHECKED = 0,
    UNCHECKED = 1,
    SEEN = 2,
    IN = 0,
    OUT = 1,
    WITHIN = 0,
    BETWEEN = 1
  };
  
  private:
  mt_Node*node;
  int index;
  de_Edge edges [NUM_EDGES];
  int mark;
  int direction;
  
  public:
  de_Port ();
  int setIndex (int index);
  int connect (de_Port*to);
  int getEdges (de_Edge*edges [], int maxEdges);
  int initialize (mt_Node*node, int index, int direction);
  mt_Node*getNode ();
  int getIndex ();
  int getMark ();
  int getDirection ();
  void setMark (int mark);
};

class de_Switch : public mt_Switch
{
  private:
  de_Port inPorts [mt_Switch::NUM_PORTS];
  de_Port outPorts [mt_Switch::NUM_PORTS];

  public:
  de_Switch (char*name, char*type);
  int _connect (int mode, int fromPort, de_Switch*toSwitch, int toPort);
  int initialize ();
  de_Port*getInPort (int p);  
  de_Port*getOutPort (int p);
};


class de_Deadlock : public mt_Graph, public mt_Follower
{
  private:
  mt_Node*node;
  int port;
  de_Port*start;
  
  de_Port**ports;
  int numPorts;
  int maxPorts;
  
  int erase ();
  int connect (mt_Node*from, mt_Node*to,  mt_Route*r);
  int connect (mt_Calculator*calculator);
  de_Port*getUncheckedPort ();
  int check (int depth, de_Port*start);
  int unsee ();
  int growPorts ();
  int addToPorts (int i, de_Port*p);
  int deadlockable ();

  public:
  de_Deadlock ();
  ~de_Deadlock ();
  int deadlockable (mt_Calculator*calculator);
  int deadlockable (mt_Route*r, int from, int to);
  int print ();
  
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
  virtual int step (mt_Node*n, int in);
};


#endif /*de_Deadlock_h*/
