#! /bin/sh

system=`uname -s``uname -r`
case $system in
	SunOS4*)
		system=sunOS
		;;
	SunOS5*)
		system=solaris
		;;
	IRIX64*)
		system=irix64
        	;;
	HP-UX*)
		system=hpux
		;;
	Linux*)
		system=linux
		;;
	OSF1*)
		system=osf1
		;;
	FreeBSD*)
		system=freebsd
		;;
	BSD*)
		system=bsd
		;;
	NetBSD*)
		system=netbsd
		;;

	*NT*)
		system=nt
		;;

	*)
		echo "Unknown system \"$system\"."
		exit 1
		;;		
esac

machine=`uname -m`
case $machine in
	sun4*)
		machine=sparc
		;;
	sparc*)
		machine=sparc
		;;
	9000/*)
		machine=hp
		;;
	i[3456]86 | i86pc)
		machine=intel
		;;
	alpha)
		machine=dec
		;;
	ppc)
		machine=ppc
		;;
	IP*)
		machine=sgi
		;;
	*)
		echo "Unknown machine \"$machine\"."
		exit 1
		;;		
esac	
 
if test x`hostname` = xmerlin
then
	machine=hp
	system=pci
fi

if test x`hostname` = xpluto
then
	machine=hp
	system=pci
fi

if test x`hostname` = xkitty
then
	machine=hp
	system=dino
fi

echo "$machine"_"$system"
exit 0
