/*
  ac_RowColumnTable.c
  ad hoc calculator
  finucane@myri.com (David Finucne)
*/

#include "insist.h"
#include "ac_RowColumnTable.h"

void*ac_RowColumnTable::operator new (size_t, int numRows, int numColumns)
{
  return malloc (sizeof (ac_RowColumnTable) +
		 sizeof (mt_Route) *
		 (numRows * numColumns * numColumns + numColumns * numRows * numRows));
}

void ac_RowColumnTable::operator delete (void*p)
{
  free (p);
}

ac_RowColumnTable::ac_RowColumnTable (int numRows, int numColumns)
{
  this->numRows = numRows;
  this->numColumns = numColumns;

  mt_Route r;
  
  for (int i = 0; i < numRows * numColumns * numColumns + numColumns * numRows * numRows; i++)
    routes [i] = r;
}

ac_RowColumnTable::~ac_RowColumnTable ()
{
}

int ac_RowColumnTable::setRowRoute (int row, int from, int to, char*hops, int numHops)
{
  mt_Route r;
  
  insist (this);
  insist (routes);
  insist (row >= 0 && row < numRows);
  insist (from >= 0 && from < numColumns);
  insist (to >= 0 && to < numColumns);
  insist (hops && numHops >= 0);
  insist (row * numColumns * numColumns + from * numColumns + to < numRows * numColumns * numColumns);
  
  r.fromBytes (hops, numHops);
  
  routes [row * numColumns * numColumns + from * numColumns + to] = r;

  insist (getRowRoute (row, from, to)->equals (&r));
  
  return 1;
  exception: return 0;
}

mt_Route*ac_RowColumnTable::getRowRoute (int row, int from, int to)
{
  insist (this);
  insist (routes);
  insist (row >= 0 && row < numRows);
  insist (from >= 0 && from < numColumns);
  insist (to >= 0 && to < numColumns);
  insist (row * numColumns * numColumns + from * numColumns + to < numRows * numColumns * numColumns);
  
  return &routes [row * numColumns * numColumns + from * numColumns + to];
  exception: return 0;
}

int ac_RowColumnTable::setColumnRoute (int column, int from, int to, char*hops, int numHops)
{
  mt_Route r;
  
  insist (this);
  insist (routes);
  insist (column >= 0 && column < numColumns);
  insist (from >= 0 && from < numRows);
  insist (to >= 0 && to < numRows);
  insist (hops && numHops >= 0);
  insist (column * numRows * numRows + from * numRows + to < numRows * numRows * numColumns);
  
  r.fromBytes (hops, numHops);
  routes [numRows * numColumns * numColumns + column * numRows * numRows + from * numRows + to] = r;
  
  insist (getColumnRoute (column, from, to)->equals (&r));
  
  return 1;
  exception: return 0;
}

mt_Route*ac_RowColumnTable::getColumnRoute (int column, int from, int to)
{
  insist (this);
  insist (routes);
  insist (column >= 0 && column < numColumns);
  insist (from >= 0 && from < numRows);
  insist (to >= 0 && to < numRows);
  insist (column * numRows * numRows + from * numRows + to < numRows * numRows * numColumns);
  
  return &routes [numRows * numColumns * numColumns + column * numRows * numRows + from * numRows + to];
  exception: return 0;
  
}


