/*
  ac_Calculator.h
  mesh calculator
  finucane@myri.com (David Finucane)
*/

#ifndef ac_Calculator_h
#define ac_Calculator_h

#include "mt_Route.h"
#include "mt_Calculator.h"
#include "mt_Host.h"
#include "mt_Follower.h"
#include "ac_RowColumnTable.h"

class ac_Calculator;
typedef int (ac_Calculator::*ac_RouteAlgorithm)(mt_Node*h1, mt_Node*h2, mt_Route*route);
typedef int (ac_Calculator::*ac_InitializeFunction) ();

class ac_Calculator : public mt_Calculator, public mt_Follower
{
  private:
  ac_RouteAlgorithm algorithm;
  ac_InitializeFunction initializeFunction;
  
  mt_Node**collectedSwitches;
  int numCollectedSwitches;
  
  /*
  This version handles as many chords as needed (stored in {V[i]}).
  each chord connect in both directions (+/-).  A simple 8x8 with no
  chords is defined by {V[2]=8, V[1]=8}..  A route is represented by the
  counters corresponding to the lengths of the chords, stored in {C[i]}.
  The shortest route is in {B[i]}.  Routes are not allowed to pass
  through S=M*N.
 */

  enum
  {
    R = 1,
    FF = 50,
    LX = 20,
  };

  int M;      // number of columns (width)
  int N;      // number of rows (height)
  int s,d;    // source and destination
  int MN;     // M*N
  int T;      // M*N + 1
  int L;      // the length of the best route
  int SL;   // Total route lengths
  int NL;   // Total number of routes computed
  int V [LX];  // the value of the each link (sorted, V[1]=1)
  int C [LX];  // the count of the each link, current route
  int B [FF][LX];  // the count of the each link, best route
  int D;      // the desired total
  int cbest;
  
  ac_RowColumnTable*rowColumnTable;
  int numRows;
  int numColumns;
  
  int algorithm_8x8 (mt_Node*h1, mt_Node*h2, mt_Route*r);
  int algorithm_3_level (mt_Node*h1, mt_Node*h2, mt_Route*r);
  int algorithm_rowColumn (mt_Node*h1, mt_Node*h2, mt_Route*r);
  int algorithm_barrel (mt_Node*h1, mt_Node*h2, mt_Route*r);
  int algorithm_spiral (mt_Node*h1, mt_Node*h2, mt_Route*r);

  int initialize_spiral ();
  int valid (int s);
  void update_route (int s);
  void tryD (int s, int D,int Level);
  int get_routes (int s, int d, mt_Node*switches []);

  int initialize_rowColumn ();
  int none ();
  
  int getRoute (mt_Route*route, mt_Node*from, mt_Node*to, mt_Node*switches[], int numSwitches, int*ports=0);
  int getSwitches (mt_Route*route, mt_Node*from, mt_Node*to, mt_Node*switches []);
  
  public:
  ac_Calculator();
  ~ac_Calculator();

  virtual int step (mt_Node*node, int);
  virtual void cleanup ();
  virtual int getRoute (int from, int to, int routeIndex, mt_Route*route);
  virtual int getMaxRoutes ();
  virtual int getNumRoutes (int from, int to);

  virtual mt_Node*newNode (int nodeType, char*name, char*type);
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);
  virtual int initialize (mt_Graph*graph, mt_Node*root);
  virtual int initialize (char*mapFile);
};

#endif /*ac_Calculator_h*/


