/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _machine_stdarg_h_
#define _machine_stdarg_h_

typedef char *va_list;

#define va_start(ap,fmt) ap = (char *) &fmt + 4
#define va_end(ap)

#define va_step(type) ((sizeof(type)+3) - ((sizeof(type)+3)&3))

#define va_arg(ap,type) (ap = ap + va_step(type), *(type *)(ap - va_step(type)))

#endif /* _machine_stdarg_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
