/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gmcp_h_
#define _gmcp_h_

#include "gm_config.h"
#include "gm_types.h"
#include "gm_debug_recv_tokens.h"
#include "gm_bootstrap.h"

/****************************************************************
 * MCP Switches
 ****************************************************************/

#define GM_DEBUG_CONNECTIONS 0

/* For validating DMA addresses for IRIX hosts */
#define GM_DEBUG_IRIX_DMA_OCTANE 1
#define GM_DEBUG_IRIX_DMA_O200   2
/* Set this to 0 for no debugging, or set it to one of the preceding values: */
#define GM_DEBUG_IRIX_DMA_ADDR 0

#if GM_DEBUG_IRIX_DMA_ADDR
extern inline void gm_check_irix_dma_addr (gm_dp_t the_addr,
                                           int refer_line, int line);
#define  GM_CHECK_IRIX_DMA_ADDR(a,b,c) gm_check_irix_dma_addr(a,b,c)
#else
#define  GM_CHECK_IRIX_DMA_ADDR(a,b,c) {}
#endif 

/****************
 * Compact switches
 ****************/

#if GM_MIN_SUPPORTED_SRAM <= 512
#define GM_STR(str) "string removed for compact MCP"
#else
#define GM_STR(str) (str)
#endif

/* disable inlining for compact build */
#if GM_MIN_SUPPORTED_SRAM <= 256
#define inline
#endif /* GM_MIN_SUPPORTED_SRAM <= 256 */

#if GM_MIN_SUPPORTED_SRAM <= 512
#define gm_printf(args...)
#define fflush(file)
#define gm_putstring(s)
#define gm_hex_dump(a,b)
#define gm_puts(args...)
#define gm_printf_p(args...)
#endif

#if GM_MIN_SUPPORTED_SRAM <= 256
#define gm_morse_async(s)
#define gm_morse_sync(s)
#endif

#define gm_puts(s)

/***********************************************************************
 * Finding GM LANai globals
 ***********************************************************************/

/* The "gm" structure includes most of the LANai globals, except those
   that are mapped into host memory.

   "GM" is an array of user-writable page-sized data structures
   associated with each port and mapped into host memory.


         ...
   |                       |
   |-----------------------|
   | GM_PORT(0)            |
   |-----------------------|
         ...
   |-----------------------|
   | GM_PORT(GM_NUM_PORTS) |
   |-----------------------|
   |                       |
   | Page hash piece       |
   |                       |
   +-----------------------+ (end of memory) */

#define GM_PORT (gm._PORT)
#define GM_PAGE_HASH_PIECE ((gm_dp_t *)&GM_PORT[GM_NUM_PORTS])

#define GM_STACK_WORDS 8*1024
extern gm_u32_t gm_stack[GM_STACK_WORDS];
extern void *gm_top_of_stack;

/****************
 * Globals in registers
 ****************/

#include "gm_enable_mcp_global_regs.h"

extern gm_lanai_globals_t _gm;

#if GM_ENABLE_MCP_GLOBAL_REGS

/* This causes compiler warnings, but the only way around that
   appears to be to modify the compiler. */

register gm_lanai_globals_t *gmptr asm ("r11");
register unsigned int _GM_STATE asm ("r12");
register gm_connection_t *gm_connection asm ("r13");	/* 74 */
register gm_port_protected_lanai_side_t *gm_port asm ("r14");	/* 121 */

#define gm (*gmptr)
#define GM_STATE _GM_STATE

#else /* GM_ENABLE_MCP_GLOBAL_REGS */

#if 0
#define gmptr (&_gm)
#define gm _gm
#define GM_STATE gm.state
#define gm_connection gm.connection
#define gm_port (gm.port)
#endif /* 0 */

#endif /* GM_ENABLE_MCP_GLOBAL_REGS */

/****************************************************************
 * 
 ****************************************************************/

/* This should be a power of 2 that is approximately the number of
   bytes the network can transfer in 1 microsecond. */

#define GM_BYTES_PER_USEC 128

#if GM_DEBUG
/* If debugging is on, the MCP runs so slowly that the timer period
   needs to be extended to prevent the timer from consuming all cycles.
   Also, be abbreviate some of the longer timeouts so errors will be
   reported more quickly. */
#define GM_TIMER_PERIOD 2000
#define GM_LOW_FREQ_TIMER_PERIOD (4000)
#define GM_SEND_TIMEOUT (2*1000*1000)
#define GM_FATAL_SEND_TIMEOUT (10*1000*1000*2)
#else /* !GM_DEBUG */

/* These are the normal timer values */
#define GM_TIMER_PERIOD 200
#define GM_LOW_FREQ_TIMER_PERIOD (2000)
#define GM_SEND_TIMEOUT 4096
#define GM_FATAL_SEND_TIMEOUT (120*1000*1000*2)

#endif /* !GM_DEBUG */

/* This must be substantially smaller than GM_FATAL_SEND_TIMEOUT */
#define GM_CONNECTION_TIMEOUT (GM_FATAL_SEND_TIMEOUT/2)

/****************************************************************
 * 
 ****************************************************************/

/* Macros for checking state bits using masks above */

#define NOTICED(something)	( GM_STATE&(something))
#define NOTICED_NO(something)	(~GM_STATE&(something))
#define NOTICED_NOT(something)	(~GM_STATE&(something))

/* Macros for setting the state using masks above */

#define TOGGLE_STATE(something)	(GM_STATE ^= (something))
#define NOTICE(something)	(GM_STATE |=  (something))
#define NOTICE_NO(something)	(GM_STATE &= ~(something))
#define NOTICE_NOT(something)	NOTICE_NO(something)

/****************
 * DISPATCH support
 ****************/

#define GM_FUNCTION_BASED_DISPATCH 1

#if GM_FUNCTION_BASED_DISPATCH
typedef struct gm_handler *gm_handler_t;

#define GOTO_PREFETCHED_HANDLER(handler) do {			\
  gm_handler_t GOTO_PREFETCHED_HANDLER_handler;			\
								\
  asm volatile ("mov %1,%?pc\n\t"				\
		"sub %?fp,8,%?sp\n\t"				\
		"nop"						\
		: "=r" (GOTO_PREFETCHED_HANDLER_handler)	\
		: "r" (handler)					\
		: "fp", "sp", "pc");				\
  /* never get here */						\
  return GOTO_PREFETCHED_HANDLER_handler;			\
} while (0)

#if !L4
#define GOTO_HANDLER_AT_OFFSET(offset) do {	\
  gm_handler_t GOTO_HANDLER_handler;		\
						\
  asm volatile ("ld [%1 add %2],%?pc\n\t"	\
		"sub %?fp,8,%?sp\n\t"		\
		"nop\n\t"			\
		"nop\n\t"			\
		"nop"				\
		: "=r" (GOTO_HANDLER_handler)	\
		: "r" (gmptr), "r" (offset)	\
		: "fp", "sp", "pc");		\
  /* never get here */				\
  return GOTO_HANDLER_handler;			\
} while (0)
#else  /* L4 */
#define GOTO_HANDLER_AT_OFFSET(offset) do {				 \
  GOTO_PREFETCHED_HANDLER (*(gm_handler_t *) ((char *) gmptr + offset)); \
} while (0)
#endif /* L4 */

#else  /* !GM_FUNCTION_BASED_DISPATCH */
#define GOTO_HANDLER_AT_OFFSET(offset) (*(void **) ((char *) gmptr + offset));
#define GOTO_HANDLER
#endif /* !GM_FUNCTION_BASED_DISPATCH */

#if GM_FUNCTION_BASED_DISPATCH
#define GM_REFERENCE_LABEL(label) ((gm_handler_t) ((char *) label + 8))
#else
#define GM_REFERENCE_LABEL(label) (&& label)
#endif

				/* Special Macro to efficiently set the
				   handler in the dispatch table. */
#define SET_HANDLER(event_type, label, label_extra) do {	\
  gm.handler[event_type]					\
    = GM_REFERENCE_LABEL (GM_CAT (label, label_extra));		\
} while (0)

#define GET_HANDLER(event_type) (gm.handler[event_type])

				/* Macro to check a handler in the dispatch
				   table. */
#define ASSERT_HANDLER(event_type, label, label_extra) do {		\
  gm_assert (gm.handler[event_type]					\
	       == GM_REFERENCE_LABEL (GM_CAT (label,label_extra)));	\
} while (0)

gm_handler_t gm_get_first_handler (void);

/****************************************************************
 * Functions exported by gmcp.c
 ****************************************************************/

void gm_reack (gm_connection_t * c);
gm_s64_t rtc64 (void);

#ifndef gm_putstring
void gm_putstring (char *s);
#endif

void prepare_to_interrupt (char *LED_msg);
void gm_interrupt (gm_u32_t type);
void await_interrupt_completion (char *LED_msg);
void gm_report_error (gm_port_protected_lanai_side_t * port,
		      enum gm_recv_event_type type);
void gm_reverse_bcopy (void *from, void *to, unsigned long len);

#endif /* _gmcp_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
