/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

 /***********************
  ** Send state machine **
  ***********************/

#if LONE == 1
				/* Send an ack. */
MARK_LABEL (L_send__start_sending_ack,)
{
  gm_connection_t *c, *c__next_to_ack;
  gm_ack_packet_t *ack_packet;
  unsigned int c__route_len;

  gm_assert (NOTICED (ACK_PENDING));
  gm_assert (NOTICED_NOT (SENDING));

  c = gm.first_connection_to_ack;
  gm_assert (c);
  gm_assert (c - &gm_connection[0] <= gm.max_node_id);
  gm_assert ((c->route_len <= GM_MAX_NETWORK_DIAMETER));
  ;
  ;

  ack_packet = &c->ack_packet;
  gm_assert (ack_packet->type == GM_PACKET_TYPE);
  gm_assert (ack_packet->sender_node_id == gm.this_node_id);
  gm_assert (c - &gm_connection[0] == ack_packet->target_node_id);

  c__next_to_ack = c->next_to_ack;
  c__route_len = c->route_len;

#if GM_ENABLE_GALVANTECH_WORKAROUND
  gm_assert (GM_OFFSETOF (gm_ack_packet_t, header_checksum)
	     == GM_OFFSETOF (gm_packet_header_t, header_checksum));
  gm_galvantech_set_header_checksum ((gm_packet_header_t *) ack_packet);

  {
    extern gm_u64_t
      copied_ack_packet[
			((sizeof (gm_ack_packet_t) + GM_MAX_NETWORK_DIAMETER)
			 / 8) + 1];
    char *smp;
    /* Send the pending ack or nack. */
    gm_bcopy (((char *) ack_packet) - GM_MAX_NETWORK_DIAMETER,
	      copied_ack_packet,
	      sizeof (gm_ack_packet_t) + GM_MAX_NETWORK_DIAMETER);
    smp = (char *) copied_ack_packet + GM_MAX_NETWORK_DIAMETER - c__route_len;

    SA = (unsigned) smp;
    SMP = smp;
#if GM_ENABLE_CRC32
    if (c__route_len)
      set_SMH ((char *) copied_ack_packet + GM_MAX_NETWORK_DIAMETER - 1);
#endif
    set_SMLT (smp + sizeof (ack_packet) + GM_MAX_NETWORK_DIAMETER);
  }
#else
  {
    char *smp;
    /* Send the pending ack or nack. */
    smp = (char *) ack_packet - c__route_len;
    SA = (unsigned) smp;
    SMP = smp;
  }
#if GM_ENABLE_CRC32
  if (c__route_len)
    set_SMH ((char *) ack_packet - 1);
#endif
  set_SMLT (ack_packet + 1);
#endif /* GM_ENABLE_GALVANTECH_WORKAROUND */

  /* Remove ack from list of connections */
  /* to ack. */
  c->ack_pending = 0;
  gm.first_connection_to_ack = c__next_to_ack;

  if (!c__next_to_ack)
    NOTICE_NO (ACK_PENDING);

#if GM_DEBUG
  if (ack_packet->subtype == GM_ACK_SUBTYPE)
    gm_printf_p ("Sent ACK (%d, %d).\n",
		 ack_packet->sexno.parts.sesno,
		 ack_packet->sexno.parts.seqno);
  else
    {
      gm_printf_p ("Sent NACK (%d, %d).\n",
		   ack_packet->sexno.parts.sesno,
		   ack_packet->sexno.parts.seqno);
    }
#endif

  GM_INCR_PACKET_CNT (gm.netsend_cnt);
  DISPATCH (133, "starting send (N)ACK");
}
GM_END_HANDLER;

#endif

MARK_LABEL (L_send__start_sending_chunk_, LZERO)
{
  void *smp;
  void *sml;
#if GM_ENABLE_CRC32
  void *smh = 0;
#endif

  gm_assert (gm.free_send_chunk_cnt < 2);
  ASSERT_HANDLER (FINISH_SEND_EVENT, L_send__finish_sending_chunk,);
  ASSERT_HANDLER (START_SEND_EVENT, L_send__start_sending_chunk_, LZERO);
  /* gm_assert (NOTICED_NOT (ACK_PENDING)); <-NO! timer can disable them. */
  gm_assert (NOTICED (SEND_PENDING));
  /* gm_assert (!ACK_OR_NACK_P (&gm.send_chunk[LZERO].payload.as_packet)); */

#if GM_CPU_lanai
  /* For embedded GM, send the data specified by the gather list in
     the send chunk.  This emulates the normal GM behaviour. */

  /* Determine what to send. */

#error feldy - need to modify this GM_CPU_lanai code for CRC32 operation
  smp = gm.send_chunk[LZERO].smp;
  if (smp)
    {
      /* send header, and mark it as sent. */

      sml = gm.send_chunk[LZERO].packet.payload;
      gm_assert (sml >= gm.send_chunk[LZERO].smp);
      gm.send_chunk[LZERO].smp = 0;

    }
  else
    {
      /* send a piece from the gather list */

      smp = gm.send_list->ptr;
      sml = gm.send_list->len;
      gm.send_list++;
    }

  /* Start sending it. */

  SA = smp;
  SMP = smp;
  if (gm.send_list < gm.send_list_end)
    {
      /* not the last gather piece */

      SML = sml;
      /* Don't notice sending, so this handler will be called again to
         send next chunk when the send completes */
    }
  else
    {
      /* last gather piece is being sent */

      SMLT = sml;
      NOTICE (SENDING);
      /* reset the send gather list */
      gm.send_chunk[LZERO].send_list
	= gm.send_chunk[LZERO].send_list_end
	= gm.send_chunk[LZERO]._send_list;
    }
#else /* GM_CPU_lanai not defined */
  {
    gm_handler_t handler, next_start_sdma_handler;
    unsigned int offset;
    gm_u32_t isr;

    smp = gm.send_chunk[LZERO].smp;
#if GM_ENABLE_CRC32
    smh = gm.send_chunk[LZERO].smh;
#endif
    sml = gm.send_chunk[LZERO].smlt;
    /*dispatch */ set_ISR (SEND_INT_BIT);
    /*dispatch */ isr = get_ISR ();
    gm_assert (GM_ALIGN (u32, sml, GM_PACKET_GRANULARITY)
	       > GM_ALIGN (u32, smp, GM_PACKET_GRANULARITY));


    if (GM_DEBUG_DIRECTED_SEND)
      {
	gm_printf (GM_STR ("send from %p: "), smp);
	gm_hex_dump (smp, (char *) sml - (char *) smp);
      }

    SA = (int) smp;
    SMP = smp;
#if GM_ENABLE_CRC32
    if (smh)
      set_SMH (smh);
#endif
    set_SMLT (sml);

    GM_INCR_PACKET_CNT (gm.netsend_cnt);

    NOTICE (SENDING);
    next_start_sdma_handler
      = GM_REFERENCE_LABEL (GM_SUB_N_CAT (L_send__start_sending_chunk_,
					  LONE));

    /*dispatch */ offset = DISPATCH_OFFSET (isr);
    gm.led = 1;
    set_LED (-1);
    gm.handler[START_SEND_EVENT] = next_start_sdma_handler;
    gm_printf_p ("Started segment send.\n");
    LOG_DISPATCH (134, "started send");
    /* dispatch */ GOTO_HANDLER_AT_OFFSET (offset);
  }
#endif
  DISPATCH (135, "started sending chunk");
}
GM_END_HANDLER;

#if LZERO == 0

/* Notice the send interface is idle and free the sent chunk. */

MARK_LABEL (L_send__finish_sending_chunk,)
{
  gm_assert (NOTICED (SENDING));
  gm_assert (get_ISR () & SEND_INT_BIT);
  gm_assert (gm.free_send_chunk_cnt < 2);

  /* Free the chunk that was just sent.  Here, GM_FREE_SEND_CHUNK_CNT
     is 1 if there no send pending or 0 if there is a send pending. */

  gm_assert (gm.free_send_chunk_cnt < 2);
  gm_assert (NOTICED (SEND_PENDING));

  {
    unsigned int gm_free_send_chunk_cnt;
    gm_u32_t isr;
    gm_handler_t handler;
    unsigned int offset;

    /* dispatch */ isr = get_ISR ();
    gm_free_send_chunk_cnt = gm.free_send_chunk_cnt;
    NOTICE_NOT (SENDING);
    NOTICE (FREE_SEND_CHUNK);
    TOGGLE_STATE (gm_free_send_chunk_cnt * SEND_PENDING);
    /*dispatch */ offset = DISPATCH_OFFSET (isr);
    ++gm_free_send_chunk_cnt;
    gm.free_send_chunk_cnt = gm_free_send_chunk_cnt;
    gm.led = 0;
    gm_printf_p ("Finished segment send.\n");
    LOG_DISPATCH (136, "finished sending chunk");
    /* dispatch */ GOTO_HANDLER_AT_OFFSET (offset);
  }
}
GM_END_HANDLER;
#endif

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
