/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: finucane@myri.com */

#ifndef _gm_mappee_h_
#define _gm_mappee_h_

#define MCP_HEADER_MAP_TYPE 5
#define MCP_HEADER_VERSION 1
#define MCP_MAP_HEADER_REPLY_TYPE 1
#define MCP_MAP_HEADER_SCOUT_TYPE 0
#define MCP_REPLY_OK 0
#define MCP_ROUTES_ONLY 1
#define MCP_MAX_DEPTH 8


typedef struct McpRoute
{
	short length;
	short route[MCP_MAX_DEPTH];
}McpRoute;
 
typedef struct McpReplyMessage
{
	short type;				/*MCP header*/
	short version;
	int length; 
	int mtype;				/*map message*/
	int phase;
	int address[2];
	int mapLevel;
	int reply;				/*host reply*/
	int port;
	int mapAddress[2];
	int mapVersion;
	int request;
	int buffer [32];
} McpReplyMessage;

typedef struct McpScoutMessage
{
	short type;				/*MCP header*/
	short version;
	int length; 
	int mtype;				/*map message*/
	int phase;
	int address[2];
	int mapLevel;
	int port;				/*host scout*/
	McpRoute from;
	short padding;
} McpScoutMessage;

int
sendMcpReplyMessage(McpScoutMessage*scout, int address[2], int mapVersion,
		    int mapAddress[2]);


#endif /* _gm_mappee_h_ */
