/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: feldy@myri.com */

/*
to create gm_lanai_rate_array.c:

lanai7-gcc -I../include -o gm_lanai_rate gm_lanai_rate.c
/bin/rm -f gm_lanai_rate_array.c
gendat --format=zlib-array --array-name=gm_control_program_lanai_rate \
         gm_lanai_rate > gm_lanai_rate_array.c
*/

#include "lanai7_def.h"


#define ONE_NOP {asm volatile ("nop");}

#define TEN_NOPS { \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); \
    asm volatile ("nop"); }

#define HUNDRED_NOPS {\
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; \
	TEN_NOPS; }

volatile unsigned int *write_stop = (volatile unsigned int *) 0x8;
volatile unsigned int *write_speed = (volatile unsigned int *) 0x4;
volatile unsigned int *write_signal = (volatile unsigned int *) 0x0;

main ()
{
  register unsigned int stop;

/*
	MYRINET = NRES_INT_BIT;
	TIMEOUT = 1;
*/

  *write_stop = 1;
  *write_speed = 2;
  *write_signal = 3;

  while (!(ISR & LINK0_INT_BIT) && (RTC < 1000000))
    {
      /* wait until TCLK is steady */
    }


  *write_stop = 4;
  *write_speed = 5;
  *write_signal = 6;

  RTC = 0;

  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;

  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;
  HUNDRED_NOPS;


  stop = RTC;

  *write_speed = 1000 * 2 / stop;
  *write_stop = stop;
  *write_signal = 0xabababab;

  while (1)
    {
      /* wait forever */
    }
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  c-backslash-column:72
  tab-width:8
  End:
*/
