/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1996, 1997, 1998, 1999, 2000 by Myricom, Inc.		 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef GM_DISPATCH_LOGGING_H
#define GM_DISPATCH_LOGGING_H 1

#include "gm_compiler.h"

/* Dispatch debug checks */


/****************
 * Dispatch logging
 ****************/

static inline void
log_it (int unique, char *msg, int lzero, char *base_msg)
{
  GM_PARAMETER_MAY_BE_UNUSED (msg);
  GM_PARAMETER_MAY_BE_UNUSED (base_msg);
  
#if GM_DEBUG || GM_LOG_DISPATCHES
  if (!*base_msg)
    return;

  gm.last_dispatch = msg;
#endif

#if GM_LOG_DISPATCHES
  gm.dispatch_cnt[unique][lzero]++;

  gm.record_log++;
  *gm.log_slot++ = msg;
  gm.logtime[gm.logtime_index++] = 
#if L4||L7
	RTC;
#else
	CPUC;
#endif
  if (gm.log_slot >= &gm.log[GM_LOG_LEN])
    {
      gm.log_slot = &gm.log[0];
      gm.logtime_index = 0;
    }
  *gm.log_slot = 0;
#else
  GM_PARAMETER_MAY_BE_UNUSED (unique);
  GM_PARAMETER_MAY_BE_UNUSED (lzero);
#endif
}

/* Macro for logging dispatchs or other dispatch-like events.  The
   logging simply adds a pointer to the log message to a circular
   queue of log pointers, which the host can read.

   HACK: The name of this macro is a minor hack to enable the
   mcp/make_dispatches pearl script to also mark direct calls to
   LOG_DISPATCH() with unique IDs. */


#ifndef LZERO
#define LZERO 0
#define LONE 1
#endif

#if GM_LOG_DISPATCHES
#define LOG_DISPATCH(unique, msg) do {					\
      log_it (unique,							\
	      __FILE__ ":" GM_SUB_N_STRINGIFY (__LINE__) ": " #msg,	\
	      LZERO, (char *) msg + 0);					\
} while (0)
#else
#define LOG_DISPATCH(unique, msg)
#endif

#endif
