/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_debug.h"
#endif

gm_status_t
gm_unique_id (gm_port_t *port, char *id)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  GM_PRINT (GM_PRINT_LEVEL >= 4,
	    ("gm_unique_id returning %x:%x:%x:%x:%x:%x\n",
	     ((char *)(is->lanai.eeprom.lanai_board_id))[0] & 0xff,
	     ((char *)(is->lanai.eeprom.lanai_board_id))[1] & 0xff,
	     ((char *)(is->lanai.eeprom.lanai_board_id))[2] & 0xff,
	     ((char *)(is->lanai.eeprom.lanai_board_id))[3] & 0xff,
	     ((char *)(is->lanai.eeprom.lanai_board_id))[4] & 0xff,
	     ((char *)(is->lanai.eeprom.lanai_board_id))[5] & 0xff));
  
  /* Copy the 6-byte ethernet address from the eeprom */
  
  return gm_copyout (ps, is->lanai.eeprom.lanai_board_id, id, 6);
#else
  /* indirectly call the kernel version of this function */
  return _gm_user_ioctl (port, GM_GET_UNIQUE_BOARD_ID, id, sizeof (*id));
#endif
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
