/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_trace.h"

#if GM_ENABLE_TRACE
gm_file_trace_t gm_trace_log[GM_HOST_NUMTRACE];
gm_atomic_t gm_trace_index;
#endif

GM_ENTRY_POINT
void
gm_tracing (gm_port_t * p, int enable)
{
  GM_PARAMETER_MAY_BE_UNUSED (p);
  GM_PARAMETER_MAY_BE_UNUSED (enable);
  
  GM_PRINT (loic, ("gm_tracing() called\n"));
  
#if GM_ENABLE_TRACE
#if !GM_KERNEL
  __gm_post_simple_send_event (p, (enable
				   ? GM_TRACE_START_EVENT
				   : GM_TRACE_STOP_EVENT));
  if (!enable)
    sleep(1);
#endif /* GM_KERNEL */
  if (enable)
    GM_ATOMIC_SET(gm_trace_index,1);
#endif /* GM_ENABLE_TRACE */
}
