/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_config.h"
#include "gm.h"

/* strncpy() copies exactly n bytes, truncating src or adding null
   characters to dst if necessary.  The result will not be
   null-terminated if the length of src is n or more. */

GM_ENTRY_POINT
char *
gm_strncpy (char *to, const char *from, int len)
{
  char *orig_to = to;

  while (len--)
    {
      *to++ = *from;
      if (*from)
	from++;
    }

  return orig_to;
}
