/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 2000 by Myricom, Inc.                             	 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"
#include "gm_debug.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

gm_status_t
gm_set_enable_nack_down(struct gm_port *port, int flag)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = ps->instance;
  
  if (!ps->opened)
  {
    GM_NOTE (("User tried API function _gm_set_enable_nack_down()"));
    _GM_NOTE (("    on port before setting port number.\n"));
    return GM_PERMISSION_DENIED;
  }
  
  gm_assert (is);
  gm_assert (is->lanai.globals);

  gm_write_lanai_global_u8 (is, port[ps->id].enable_nack_down_flag, flag);
  
  return GM_SUCCESS;
#else
  return _gm_user_ioctl (port, GM_SET_ENABLE_NACK_DOWN, &flag, sizeof (int));
#endif
}
