/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#include "gm_debug.h"
#endif

/* Note: the MASK is a long to support larger than 2GByte packets
   (those with size larger than 31).   */

GM_ENTRY_POINT
gm_status_t
gm_set_acceptable_sizes (struct gm_port *p, enum gm_priority priority,
			 gm_size_t mask)
{
#if GM_KERNEL
  gm_port_state_t *ps = p->kernel_port_state;
  gm_instance_state_t *is = ps->instance;

  if (!ps->opened)
    {
      GM_NOTE (("User tried API function gm_set_acceptable_sizes()\n"
		"\ton port before setting port number.\n"));
      return GM_PERMISSION_DENIED;
    }
  
  if (!is->lanai.running)
    return GM_INTERNAL_ERROR;

  if (priority != GM_LOW_PRIORITY && priority != GM_HIGH_PRIORITY)
    return GM_INVALID_PARAMETER;

#ifdef __GNUC__
#  if GM_SIZEOF_VOID_P > 4
  /* #    warning scrunching mask in gm_set_acceptable_sizes (message size will be limited to 4GBytes) */
#  endif
#endif

  gm_write_lanai_global_u32 (is,
			     port[ps->id].unacceptable_recv_sizes[priority],
			     (gm_u32_t) ~mask);

  return GM_SUCCESS;
#else
  gm_u32_t kmask = GM_STATIC_CAST (gm_u32_t, mask);
  if (sizeof (mask) > 4)
    {
      gm_always_assert(mask <= 0xffffffffUL);
    }

  gm_assert (p);
  gm_assert (priority == GM_LOW_PRIORITY ||
	       priority == GM_HIGH_PRIORITY);

  return _gm_user_ioctl (p, (priority == GM_LOW_PRIORITY
			     ? GM_SET_ACCEPTABLE_SIZES_LOW
			     : GM_SET_ACCEPTABLE_SIZES_HIGH),
			 &kmask, sizeof (kmask));
#endif
}
