/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1998 by Myricom, Inc.                                   *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_config.h"		/* must be first for firmware builds */

#include "gm.h"

#if GM_OS_VXWORKS && !GM_BUILDING_FIRMWARE
#include "vxWorks.h"
#endif /* GM_OS_VXWORKS && !GM_BUILDING_FIRMWARE*/

#include <stdarg.h>

#if !GM_KERNEL
#include <stdio.h>
#endif

GM_ENTRY_POINT int
gm_printf (const char *format, ...)
{
  va_list ap;
  int ret;

  va_start (ap, format);
#if GM_BUILDING_FIRMWARE
  ret = vfprintf (stdout, format, ap);
  fflush (stdout);
#elif GM_KERNEL
  ret = gm_arch_vprintf (GM_PRINT_CONTINUE, format, ap);
#else
  ret = vprintf (format, ap);
#endif
  va_end (ap);

  return ret;
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
