/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include <stdlib.h>
#include "gm.h"
#include "gm_on_exit.h"

#if HAVE_ON_EXIT && !GM_KERNEL && STDC_HEADERS
#include <stdlib.h>
#elif HAVE_ATEXIT && !GM_KERNEL && STDC_HEADERS
#include <stdlib.h>
#endif

/* This function causes all gm_on_exit() registered callbacks
   to be called in the reverse order they were registered. */

#if HAVE_ON_EXIT && !GM_KERNEL
static
void
on_exit_callback (int status, void *arg)
{
  _gm_perform_on_exit_callbacks (status == 0 ? GM_SUCCESS : GM_FAILURE);
}
#endif /* HAVE_ON_EXIT */

#if HAVE_ATEXIT && !GM_KERNEL
static
void
atexit_callback ()
{
  _gm_perform_on_exit_callbacks (GM_FAILURE);
}
#endif /* HAVE_ATEXIT */

static gm_inline
gm_status_t
gm_init_on_exit ()
{
  static int initialized;

  if (initialized)
    {
      return GM_SUCCESS;
    }
  
#if HAVE_ON_EXIT && !GM_KERNEL
  if (0 != on_exit (on_exit_callback, NULL))
    {
      return GM_FAILURE;
    }
#elif HAVE_ATEXIT && !GM_KERNEL
  if (0 != atexit (atexit_callback))
    {
      return GM_FAILURE;
    }
#endif /* HAVE_ATEXIT && !GM_KERNEL */

  initialized = 1;
  return GM_SUCCESS;
}

/* Like Linux on_exit().  Call the callbacks in the reverse order
   registered inside gm_exit(), passing GM exit status and registered
   argument to the callback. */

GM_ENTRY_POINT
gm_status_t
gm_on_exit (gm_on_exit_callback_t callback, void *arg)
{
  gm_on_exit_record_t *record;
  gm_status_t status;
  
  status = gm_init_on_exit ();
  if (status != GM_SUCCESS)
    {
      goto abort_with_nothing;
    }
  record = (gm_on_exit_record_t *) gm_malloc (sizeof (gm_on_exit_record_t));
  if (!record)
    {
      status = GM_OUT_OF_MEMORY;
      goto abort_with_init;
    }
  record->next = _gm_first_on_exit_record;
  record->callback = callback;
  record->arg = arg;
  _gm_first_on_exit_record = record;
  return GM_SUCCESS;

 abort_with_init:
 abort_with_nothing:
  return status;
}
