/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_debug.h"
#endif

GM_ENTRY_POINT
char *
gm_node_id_to_host_name (gm_port_t *port, unsigned int node_id)
{
#if GM_KERNEL
  char *ret;
  
  ret = port->kernel_port_state->instance->name_table.entry[node_id];
  if (*ret == 0)
    {
      GM_PRINT (GM_PRINT_LEVEL >= 3, ("failed\n"));
      return (char *) 0;
    }

  GM_PRINT (GM_PRINT_LEVEL >= 3, ("%d->%s.\n", node_id, ret));
  return ret;
#else /* !GM_KERNEL */
  static union {
    unsigned int in;
    char out[GM_MAX_HOST_NAME_LEN+1];
  } buf;
  gm_status_t status;
  
  buf.in = node_id;
  status = _gm_user_ioctl (port, GM_NODE_ID_TO_HOST_NAME, &buf, sizeof (buf));
  if (status != GM_SUCCESS)
    return 0;
  buf.out[GM_MAX_HOST_NAME_LEN] = 0;
  return buf.out;
#endif /* !GM_KERNEL */
}
