/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1998 by Myricom, Inc.                                   *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_compiler.h"
#include "gm_internal.h"

/* author: glenn@myri.com */

GM_ENTRY_POINT struct gm_mutex *
gm_create_mutex ()
{
#if GM_KERNEL
  gm_arch_sync_t *sync;

  sync = (gm_arch_sync_t *) gm_malloc (sizeof (gm_arch_sync_t));
  if (!sync)
    return 0;
  gm_arch_sync_init (sync, 0);
  return (struct gm_mutex *) sync;
#else
  return (struct gm_mutex *) 1;
#endif
}

GM_ENTRY_POINT void
gm_destroy_mutex (struct gm_mutex *mu)
{
#if GM_KERNEL
  gm_arch_sync_destroy ((gm_arch_sync_t *) mu);
  gm_free (mu);
#else
  GM_PARAMETER_MAY_BE_UNUSED (mu);
#endif
}

GM_ENTRY_POINT void
gm_mutex_enter (struct gm_mutex *mu)
{
  gm_assert (mu);
#if GM_KERNEL
  gm_arch_mutex_enter ((gm_arch_sync_t *) mu);
#else
#endif
}

GM_ENTRY_POINT void
gm_mutex_exit (struct gm_mutex *mu)
{
  gm_assert (mu);
#if GM_KERNEL
  gm_arch_mutex_exit ((gm_arch_sync_t *) mu);
#else
#endif
}





/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
