/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/


/* 
   This function exists to allow gm_board_info to have a guess
   for an upper limit to the actual number of nodes in the route table
   Without it, gm_board_info calls thousands of gm_get_route() calls.
   When debugging, this is really a mess.
*/

#include "gm_call_trace.h"
#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#endif

#define GM_DEBUG_MAX_NODE_ID_INUSE 0

#if GM_DEBUG_MAX_NODE_ID_INUSE
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

GM_ENTRY_POINT
gm_status_t
gm_max_node_id_inuse (gm_port_t *port, unsigned int *n)
{
#if GM_KERNEL
  gm_port_state_t *ps = port->kernel_port_state;
  gm_instance_state_t *is = NULL;
  unsigned int i;
  /* 16 to cover repeatedly restarting pt-to-pt case this is a hack */
  unsigned int max_id=16;

  GM_CALLED_WITH_ARGS (("%p,%p", port, n));
  
  if (!ps) {
    GM_RETURN_STATUS (GM_UNATTACHED);
  }

  is = port->kernel_port_state->instance;
  if (!is) {
    GM_RETURN_STATUS (GM_UNATTACHED);
  }

  if (!is->lanai.globals) {
    GM_PRINT (GM_DEBUG_MAX_NODE_ID_INUSE, ("lanai.globals is NULL\n"));
    GM_RETURN_STATUS (GM_UNATTACHED);
  }

  if (!is->lanai.running) {
    GM_PRINT (GM_DEBUG_MAX_NODE_ID_INUSE, ("lanai.running is false\n"));
    GM_RETURN_STATUS (GM_UNATTACHED);
  }

  /* search for the max valid one */

  for (i=1; i<is->max_node_id; i++)
    {
      /* if connection has route */
      if (gm_read_lanai_global_u8 (is, connection[i].has_route))
	{
	  GM_PRINT (GM_PRINT_LEVEL >= 4,
		    ("gm_max_node_id_inuse: found route at gmID = %d\n",i));
	  max_id = i;
	}
    }

  /* Return result */
  GM_RETURN_STATUS (gm_copyout (port->kernel_port_state, &max_id, n,
				sizeof (unsigned int)));

#else
  gm_status_t status = GM_SUCCESS;

  status = _gm_user_ioctl (port, GM_GET_MAX_NODE_ID_INUSE, n,
			       sizeof (unsigned int));

  if (status != GM_SUCCESS)
    *n = 0;

  return status;
#endif
}

