/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_internal.h"
#include "gm_malloc_debug.h"
#include "gm_debug_malloc.h"

#if !GM_KERNEL
#include <stdlib.h>
#endif

#if GM_DEBUG_MALLOC
struct gm_mdebug *gm_mdebug_root;
#endif

/* Return a pointer to the specified amount of memory.  In the kernel,
   the memory will be nonpageable. */

void *
_gm_malloc (unsigned long len)
{
  if (!len) 
    {
      return((void *)0);
    }

#if GM_KERNEL
  GM_CALLED ();
  GM_RETURN_PTR (gm_arch_kernel_malloc (len, 0));
#else
  return malloc (len);
#endif
}

GM_ENTRY_POINT
void *
gm_malloc (gm_size_t len)
{
  void *ret;
  
  if (!len) 
    {
      return((void *)0);
    }

  ret = _gm_malloc (GM_STATIC_CAST (unsigned long, GM_MDEBUG_INTERNAL_LEN (len)));
  if (!ret)
    return ret;
  ret = GM_MDEBUG_CLIENT_PTR (ret);
  GM_MDEBUG_RECORD_CLIENT_PTR (ret, gm_free);

#if GM_KERNEL_MALLOC_ALIGNS_PAGES && GM_KERNEL
  gm_assert (GM_PAGE_ALIGNED (ret);
#endif

  GM_PRINT (GM_PRINT_LEVEL >= 10, ("0x%p len = 0x%lx  allocated by gm_malloc\n", ret,len));

#if GM_KERNEL_MALLOC_ALIGNS_PAGES && GM_KERNEL
  gm_assert (GM_PAGE_ALIGNED (ret));
#endif
  return ret;
}
