/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_internal.h"

#define GM_DEBUG_HOSTNAME_TO_NODE_ID 0

#if GM_DEBUG_HOSTNAME_TO_NODE_ID
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

GM_ENTRY_POINT unsigned int
gm_host_name_to_node_id (gm_port_t *port, char *_host_name)
{
#if GM_KERNEL
  gm_port_state_t *ps;
  gm_instance_state_t *is;
  unsigned node_id;
  char host_name[GM_MAX_HOST_NAME_LEN];
  gm_status_t status;

  GM_CALLED ();
  
  ps = port->kernel_port_state;
  gm_assert (ps);
  is = ps->instance;
  gm_assert (is);
  
  if (!_host_name)
    {
      GM_RETURN_INT (GM_NO_SUCH_NODE_ID);
    }

  /* Copy the hostname passed by the user */
  
  status = gm_copyin (ps, _host_name, host_name, GM_MAX_HOST_NAME_LEN);
  if (status != GM_SUCCESS)
    {
      GM_RETURN_INT (GM_NO_SUCH_NODE_ID);
    }
  
  /* Scan for match */

  GM_PRINT (GM_DEBUG_HOSTNAME_TO_NODE_ID,
		 ("is->max_node_id=%u\n", is->max_node_id));
  for (node_id = 1; node_id <= is->max_node_id; node_id++)
    {
      GM_PRINT (GM_DEBUG_HOSTNAME_TO_NODE_ID,
		     ("examining name %u at %p\n", node_id,
		      is->name_table.entry[node_id]));
      if (!gm_strncasecmp (host_name, is->name_table.entry[node_id],
			   GM_MAX_HOST_NAME_LEN))
	{
	  GM_RETURN_INT (node_id);
	}
    }
  
  GM_RETURN_INT (GM_NO_SUCH_NODE_ID);
#else /* !GM_KERNEL */
  char host_name[GM_MAX_HOST_NAME_LEN] = {0};
  gm_status_t status;

  if (!host_name || !_host_name)
    {
      return GM_NO_SUCH_NODE_ID;
    }

  gm_strncpy (host_name, _host_name, GM_MAX_HOST_NAME_LEN);
  status = _gm_user_ioctl (port, GM_HOST_NAME_TO_NODE_ID, host_name,
			   GM_MAX_HOST_NAME_LEN);
  if (status != GM_SUCCESS)
    return GM_NO_SUCH_NODE_ID;
  return *(unsigned int *)host_name;
#endif /* !GM_KERNEL */
}
