/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if GM_KERNEL
#include "gm_pio.h"
#include "gm_debug.h"
#endif

GM_ENTRY_POINT gm_status_t
gm_get_node_id (gm_port_t *port, unsigned int *node_id)
{
#if GM_KERNEL
  gm_instance_state_t *is;
  gm_port_state_t *ps;
  unsigned int lanai_node_id;
  
  gm_assert (port);
  ps = port->kernel_port_state;
  gm_assert (ps);
  is = ps->instance;
  gm_assert (is);
  gm_assert (is->lanai.globals);

  lanai_node_id = gm_read_lanai_global_u16 (is, this_node_id);
  
  GM_PRINT (GM_PRINT_LEVEL >= 4,
	    ("gm_get_node_id: returning node ID = %d.\n", lanai_node_id));

/*
  This code doesn't work for systems that can't return ioctl data if failed.
  See how it is implemented now below at the user level.

  if (lanai_node_id == GM_NO_SUCH_NODE_ID)
    return GM_NODE_ID_NOT_YET_SET;
*/

#if 0 && GM_OS_VXWORKS
#error Bob broke this for VxWorks, while fixing other archs.  --Glenn
#endif
  
  return gm_copyout (port->kernel_port_state,
		     &lanai_node_id, node_id,
		     sizeof (unsigned));
#else
  gm_status_t status = GM_SUCCESS;
  
  if (!port->this_node_id)
    {
      status = _gm_user_ioctl (port, GM_GET_NODE_ID, &port->this_node_id,
			       sizeof (port->this_node_id));
    }
  *node_id = port->this_node_id;
  if (port->this_node_id == GM_NO_SUCH_NODE_ID)
     return GM_NODE_ID_NOT_YET_SET;
  return status;
#endif
}
