/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_compiler.h"
#include "gm_internal.h"
#include "gm_trace.h"

gm_status_t gm_get_ktrace (gm_port_t *port, gm_file_trace_t *buf)
{
  GM_PARAMETER_MAY_BE_UNUSED (port);
  GM_PARAMETER_MAY_BE_UNUSED (buf);
  
#if GM_ENABLE_TRACE
  
#if GM_KERNEL
  {
    gm_u32_t index;
    
    index = GM_ATOMIC_READ(gm_trace_index);
    /* FIXME: this is badly written */
    if (index == 0) 
      {
	index = 1;
	gm_trace_log[0].evt = 0;
      }
    else
      {
	gm_trace_log[0].evt = index;
      }
    return gm_copyout (port->kernel_port_state, gm_trace_log, buf,
		       sizeof(buf[0])*index);
  }
#else  /* !GM_KERNEL */
  return _gm_user_ioctl (port, GM_GET_KTRACE, buf,
			 sizeof (buf[0]) * GM_HOST_NUMTRACE);
#endif /* !GM_KERNEL */
  
#else  /* !GM_ENABLE_TRACE */
  return GM_SUCCESS;
#endif
}
