/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_debug_mem_register.h"

#if !GM_KERNEL
				/* mmap() */
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_MMAN_H
#include <sys/mman.h>
#endif

#endif /* GM_KERNEL */

GM_ENTRY_POINT void *
gm_dma_malloc (struct gm_port *p, gm_size_t length)
{
#if 0 && GM_CAN_REGISTER_MEMORY && GM_OS_VXWORKS
  /* removed because it doesn't seem to be needed anymore - nelson */

  void *ptr;
  gm_status_t status;

  ptr = gm_malloc (length);
  if (!ptr)
    goto abort_with_nothing;
  status = gm_register_memory (p, ptr, length);
  if (status != GM_SUCCESS)
    goto abort_with_malloc;
  return ptr;

abort_with_malloc:
  gm_free (ptr);
abort_with_nothing:
  return 0;
#else
  void *ret;
  int i;

  if (!length)
    length = 1;

  /* Try to allocate a buffer from the
     existing memory allocation
     zones. */
  for (i = p->num_zones - 1; i >= 0; i--)
    {
      ret = gm_zone_malloc (p->dma_zone[i], length);
      if (ret)
	return (ret);
    }
  gm_assert (i == -1);
  /* Could not allocate the buffer from
     the existing zones */

  /* First, check if the requested
     length is too large to possibly be
     allocated, even if we fully expand
     the copy block. */

#if !GM_CAN_REGISTER_MEMORY
  if (length > p->mappings->copy_block.len / 2)
    return 0;
#endif

  /* Try to create bigger zones until
     the alloc succeeds or we cannot
     create a bigger zone.  */
  do
    {
      void *addr;
      gm_size_t alloc_len;

      alloc_len = p->alloced_dma_mem_len;
      if (!alloc_len)
	alloc_len = GM_PAGE_LEN;
      gm_assert (GM_POWER_OF_TWO (alloc_len));

#if GM_CAN_REGISTER_MEMORY
      addr = gm_alloc_pages (alloc_len);
      if (addr == 0)
	return 0;

      GM_PRINT(GM_DEBUG_MEM_REGISTER,
               ("gm_dma_malloc() will register %d new page[s] at 0x%p\n",
                GM_PAGE_ROUNDUP(u32, alloc_len) / GM_PAGE_LEN, addr));

      /* bzero the page[s] to fault it [them] into memory */
      gm_bzero (addr, alloc_len);
/*
      mlock (addr, alloc_len);
*/

      gm_assert (GM_PAGE_ALIGNED (addr));
      if (gm_register_memory (p, addr, alloc_len) != GM_SUCCESS)
	{
	  gm_free_pages (addr, alloc_len);
	  return 0;
	}
#else
      if (_gm_mmap (p, (p->mappings->copy_block.offset
			+ (gm_offset_t) p->alloced_dma_mem_len),
		    alloc_len, GM_MAP_READ | GM_MAP_WRITE,
		    &addr) != GM_SUCCESS)
	return 0;
      if (!GM_PAGE_ALIGNED (addr))
	GM_NOTE (("Zone is not page aligned.  "
		  "Performance will be impacted.\n"));
#endif

      /* Create a new zone */

      p->dma_zone[p->num_zones] = gm_zone_create_zone (addr, alloc_len);
      if (!p->dma_zone[p->num_zones])
	goto abort_with_addr;
      p->dma_zone_base[p->num_zones] = addr;
      p->dma_zone_len[p->num_zones] = alloc_len;
      p->num_zones++;
      p->alloced_dma_mem_len += alloc_len;
      ret = gm_zone_malloc (p->dma_zone[p->num_zones - 1], length);
      continue;

    abort_with_addr:
#if GM_CAN_REGISTER_MEMORY
      gm_deregister_memory (p, addr, alloc_len);
      gm_free_pages (addr, alloc_len);
#else
      _gm_munmap (p, addr, alloc_len);
#endif
      return 0;

    }
  while (!ret);

  return ret;
#endif
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
