/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_internal.h"

GM_ENTRY_POINT void
gm_dma_free (gm_port_t *p, void *addr)
{
  int i;
				/* Find the zone this pointer belongs
                                   to and free it */
  for (i = p->num_zones-1; i >= 0; i--)
    {
      if (gm_zone_addr_in_zone (p->dma_zone[i], addr))
	{
	  gm_zone_free (p->dma_zone[i], addr);
	  return;
	}
    }
  GM_NOTE (("gm_dma_free: pointer does not belong to this port.\n"));
}
