/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_internal.h"
#include "gm_send_queue.h"

#define GM_DEBUG_DIRECTED_SEND 0

/* Perform a directed send */
GM_ENTRY_POINT
void
gm_directed_send_with_callback (gm_port_t * p, void *source_buffer,
				gm_remote_ptr_t target_buffer,
				gm_size_t len,
				enum gm_priority priority,
				unsigned int target_node_id,
				unsigned int target_port_id,
				gm_send_completion_callback_t callback,
				void *context)
{
  gm_assert (p);
  gm_assert (source_buffer);
  gm_assert (target_buffer);

#if 0
  if (!GM_ALIGNED (source_buffer, 8)
      || !GM_ALIGNED (target_buffer, 8)
      || !GM_ALIGNED (len, 8))
    {
      GM_WARN (("this function only works for 8-byte-aligned pointers"
		" and lengths\n"));
      _GM_WARN (("    NOT sending message\n\n"));
      return;
    }
#endif

  GM_SIMULATE_SIMULATE ( );

  GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	    ("gm_directed_send (\n"));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  port = %p\n", p));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  source_buffer = %p\n", source_buffer));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  target_buffer = "GM_U64_TMPL"\n", GM_U64_ARG (target_buffer)));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  len = 0x%lx\n", len));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  priority = %d\n", priority));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  target_node_id = %d\n", target_node_id));
  _GM_PRINT (GM_DEBUG_DIRECTED_SEND,
	     ("  target_port_id = %d) called.\n", target_port_id));
  
  /* Pass send token to LANai.  Care must be taken to flush the message to
     memory before flushing the token, and the token should be flushed to
     memory immediately. */

  {
    struct gm_directed_send_send_event volatile *se;
    struct gm_directed_send_send_event batch_write;

    se = GM_SEND_QUEUE_SLOT (p, callback, context, directed_send);
    
    if (GM_STRUCT_WRITE_COMBINING)
      {
	batch_write.target_buffer = gm_hton_rp (target_buffer);
	batch_write.source_buffer = gm_hton_up ((gm_up_t) source_buffer);
	batch_write.length = gm_hton_u32 ((gm_u32_t) len);
	batch_write.target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
	batch_write.target_subport_id
	  = gm_hton_u8 ((gm_u8_t) GM_SUBPORT (priority, target_port_id));
	batch_write.type = gm_hton_u8 ((gm_u8_t) GM_DIRECTED_SEND_EVENT);
	GM_COPY_TO_IO_SPACE (*se, batch_write);
      }
    else
      {
	se->target_buffer = gm_hton_rp (target_buffer);
	se->source_buffer = gm_hton_up ((gm_up_t) source_buffer);
	se->length = gm_hton_u32 ((gm_u32_t) len);
	se->target_node_id = gm_hton_u16 ((gm_u16_t) target_node_id);
	se->target_subport_id
	  = gm_hton_u8 ((gm_u8_t) GM_SUBPORT (priority, target_port_id));
	GM_STBAR ();
	se->type = gm_hton_u8 (GM_DIRECTED_SEND_EVENT);
      }
    GM_FLUSH_SEND_EVENT (p, se);
  }
}

/* Handler to emulate the old-style GM behaviour of automatically
   freeing the send token upon the completion of a directed send. */

static
void
_gm_directed_sent (struct gm_port *p, void *context, gm_status_t stat)
{
  if (stat != GM_SUCCESS)
    {
      gm_perror ("directed send failed", stat);
#if !GM_KERNEL
      gm_exit (stat);
#endif /* GM_KERNEL */
    }
  

  __gm_free_send_tokens (p,
			 (context == (void *) GM_HIGH_PRIORITY
			  ? GM_HIGH_PRIORITY
			  : GM_LOW_PRIORITY),
			 1);
}

GM_ENTRY_POINT
void
gm_directed_send (gm_port_t * p, void *source_buffer,
		  gm_remote_ptr_t target_buffer,
		  gm_size_t len,
		  enum gm_priority priority,
		  unsigned int target_node_id,
		  unsigned int target_port_id)
{
  gm_directed_send_with_callback (p, source_buffer, target_buffer, len,
				  priority, target_node_id, target_port_id,
				  _gm_directed_sent, (void *) priority);
}
