/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file includes most of the code responsible for tracking which
   pages are safe to DMA into. */

#include "gm_config.h"

#include "gm_bitmap.h"
#include "gm_compiler.h"
#include "gm_debug.h"
#include "gm_debug_lanai_dma.h"
#include "gm_types.h"

gm_status_t
__gm_noticed_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  if (GM_DEBUG_LANAI_DMA)
    {
      gm_always_assert (bitmap);
      if (GM_BITMAP_WRAPPING_GET (*bitmap, GM_DP_PAGE_NUM (dp)) == 0)
	{
	  GM_WARN (("dp=" GM_U64_TMPL " appears invalid\n",
		    GM_U64_ARG (dp)));
	  return GM_FAILURE;
	}
    }
  return GM_SUCCESS;
}

void
__gm_notice_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  if (GM_DEBUG_LANAI_DMA)
    {
      static gm_dp_t min_dp;
      static gm_dp_t max_dp;
      static gm_dp_t have_min;
      static gm_dp_t have_max;

      if (dp < min_dp || !have_min)
	{
	  min_dp = dp;
	  have_min = 1;
	}
      if (dp > max_dp || !have_max)
	{
	  max_dp = dp;
	  have_max = 1;
	}
      if (have_min
	  && have_max
	  && GM_DP_PAGE_NUM (max_dp - min_dp) > GM_MAX_HOST_DMA_PAGES)
	{
	  GM_WARN (("DMA address range is too large:\n"));
	  _GM_WARN (("    max_dma_page - min_dma_page = "
		     GM_U64_TMPL" - "GM_U64_TMPL" = "GM_U64_TMPL"\n",
		     GM_U64_ARG (GM_DP_PAGE_NUM (max_dp)),
		     GM_U64_ARG (GM_DP_PAGE_NUM (min_dp)),
		     GM_U64_ARG (GM_DP_PAGE_NUM (max_dp - min_dp))));
	  _GM_WARN (("    > GM_MAX_HOST_DMA_PAGES = "GM_U64_TMPL"\n",
		     GM_U64_ARG (GM_MAX_HOST_DMA_PAGES)));
	  _GM_WARN
	    (("GM_DEBUG_LANAI_DMA feature may not catch all bad DMAs.\n"));
	}
      gm_always_assert (bitmap);
      GM_BITMAP_WRAPPING_SET (*bitmap, GM_DP_PAGE_NUM (dp));
      GM_PRINT (GM_TRACE_LANAI_DMA, ("noticed DMA address 0x%x%08x\n",
				     (gm_u32_t) dp >> 31 >> 1,
				     (gm_u32_t) dp));
    }
}

void
__gm_forget_dma_addr (gm_dma_page_bitmap_t *bitmap, gm_dp_t dp)
{
  if (GM_DEBUG_LANAI_DMA)
    {
      gm_always_assert (*bitmap);
      GM_BITMAP_WRAPPING_CLEAR (*bitmap, GM_DP_PAGE_NUM (dp));
      GM_PRINT (GM_TRACE_LANAI_DMA, ("forgot DMA address 0x%x%08x\n",
				     (gm_u32_t) dp >> 31 >> 1,
				     (gm_u32_t) dp));
    }
}


/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
