#include "gm_internal.h"

static gm_inline void
gm_crc_iterate (char c, gm_u32_t *accum)
{
  *accum = ((*accum << 8) | (c & 0xff)) ^ gm_crc_table[(*accum>>24) & 0xff];
}

GM_ENTRY_POINT unsigned long
gm_crc (void *_ptr, gm_size_t len)
{
  gm_u32_t accum = 0;
  char *ptr;

  ptr = (char *) _ptr;
  while (len--)
    gm_crc_iterate (*ptr++, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_assert (sizeof (unsigned long) >= sizeof (gm_u32_t));
  return (unsigned long) accum;
}

GM_ENTRY_POINT unsigned long
gm_crc_str (const char *ptr)
{
  gm_u32_t accum = 0;

  while (*ptr)
    gm_crc_iterate (*ptr++, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_crc_iterate (0, &accum);
  gm_assert (sizeof (unsigned long) >= sizeof (gm_u32_t));
  return accum;
}
