/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

GM_ENTRY_POINT
gm_status_t
_gm_cop_wakeup (struct gm_port *port)
{
#if GM_KERNEL  
  gm_instance_state_t *is = port->kernel_port_state->instance;
  return __gm_cop_wakeup (is) == 0 ? GM_SUCCESS : GM_FAILURE;
#else
  unsigned int unused;
  return _gm_user_ioctl (port, GM_COP_WAKEUP, &unused, sizeof(unsigned int));
#endif
}

GM_ENTRY_POINT
gm_status_t
_gm_cop_end (struct gm_port *port)
{
#if GM_KERNEL
  gm_instance_state_t *is = port->kernel_port_state->instance;
  return __gm_cop_end (is) == 0 ? GM_SUCCESS : GM_FAILURE;
#else
  unsigned int unused;
  return _gm_user_ioctl (port, GM_COP_END, &unused, sizeof(unsigned int));
#endif
}


GM_ENTRY_POINT
gm_status_t
_gm_cop_send (struct gm_port *port, int d)
{
#if GM_KERNEL
  gm_instance_state_t *is = port->kernel_port_state->instance;
  return __gm_cop_send (is, d) == 0 ? GM_SUCCESS : GM_FAILURE;
#else
  return _gm_user_ioctl (port, GM_COP_SEND, &d, sizeof (int));
#endif
}

GM_ENTRY_POINT
gm_status_t
_gm_cop_receive (struct gm_port *port, int*d)
{
#if GM_KERNEL
  gm_instance_state_t *is = port->kernel_port_state->instance;
  *d = __gm_cop_receive (is);
  return GM_SUCCESS;  
#else
  return _gm_user_ioctl (port, GM_COP_RECEIVE, d, sizeof (int));
#endif
}

#if !GM_KERNEL
GM_ENTRY_POINT
gm_status_t
_gm_user_write_lanai_register (struct gm_port *port, gm_u32_t offset, gm_u32_t value)
{
  gm_lanai_register_access_t a;  
  a.offset = offset;
  a.value = value;
  
  return _gm_user_ioctl (port, GM_WRITE_LANAI_REGISTER, &a, sizeof (gm_lanai_register_access_t));
}
#endif
