/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#ifndef _gm_cmp64_h_
#define _gm_cmp64_h_

#include "gm.h"

/* Compare 64-bit sequence numbers. Return 0 if equal, negative if
   a<b, and positive if a>b. */

static gm_inline int
gm_cmp64 (gm_u64_t a, gm_u64_t b)
{
  register gm_u64_t val;
  val = a - b;
  if ((val >> 63) & 1)
    return -1;
  else if (val)
    return 1;
  else
    return 0;
}

#endif /* _gm_cmp64_h_ */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
