/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 2000 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_internal.h"
#include "gm_call_trace.h"

static gm_size_t depth;
static const char gm_call_trace_space[] = {' ',' ',' ',' ',' ',' ',' ',' ',
                                           ' ',' ',' ',' ',' ',' ',' ',' ',
                  /* array of 40 */        ' ',' ',' ',' ',' ',' ',' ',' ',
                                           ' ',' ',' ',' ',' ',' ',' ',' ',
                                           ' ',' ',' ',' ',' ',' ',' ',' ',
                                           '\0'};
static const char *
print_space_for_depth (gm_size_t the_depth)
{
  return &gm_call_trace_space[((sizeof (gm_call_trace_space) - 1)
			       - (the_depth
				  % (sizeof (gm_call_trace_space) - 1)))];
}

const char *
__gm_print_called_space (void)
{
  const char *ret;
  
  depth++;
  ret = print_space_for_depth (depth);
  return ret;
}

const char *
__gm_print_return_space (void)
{
  const char *ret;
  
  ret = print_space_for_depth (depth);
  depth--;
  return ret;
}
