/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if !GM_KERNEL
#ifdef STDC_HEADERS
# include <string.h>
#elif defined HAVE_STRINGS_H
# include <strings.h>
#endif
#endif

/* A reasonably fast bzero, that does not use partword I/O unless it must
   (for speed, especialy when doing PIO), and does not rely on the
   system bzero() functionality, which may not be safe for PIO mapped
   memory. */

void
gm_safer_bzero (void *ptr, int len)
{
  /* Clear 8 bytes at a time, if possible. */
  
  if (((long) ptr & 7) == 0)
    {
      while (len >= 8)
	{
	  *(gm_u64_t *) ptr = (gm_u64_t) 0;
	  ptr = (void *) ((char *) ptr + 8);
	  len -= 8;
	}
    }
  
  /* Clear 4 bytes at a time, if possible. */
  
  if (((long) ptr & 3) == 0)
    {
      while (len >= 4)
	{
	  *(gm_u32_t *) ptr = (gm_u32_t) 0;
	  ptr = (void *) ((char *) ptr + 4);
	  len -= 4;
	}
    }
  
  /* Clear remaining bytes, one at a time. */
  
  while (len >= 1)
    {
      *(gm_u8_t *) ptr = (gm_u32_t) 0;
      ptr = (void *) ((char *) ptr + 1);
      len -= 1;
    }
}

GM_ENTRY_POINT
void
gm_bzero (void *ptr, gm_size_t len)
{
#ifdef CSPI_MAP26xx
#warning No one can think of a reasons for this special case.
#warning Please try deleting it once things are working.  Thanks. --Glenn
  extern void CK_bcopy(char *src, char *dest, int length);
  gm_u8_t *zero_ptr;
  int i;
  zero_ptr = (gm_u8_t *)gm_malloc(len);
  if (zero_ptr) 
    {
       for (i=0; i<len; i++)
         zero_ptr[i] = 0;
       CK_bcopy(zero_ptr,ptr,len);
       gm_free(zero_ptr);
    }
  return;
#elif GM_OS_VXWORKS
  bzero (ptr, len);
#elif GM_OS_LINUX && !GM_CPU_powerpc
  gm_safer_bzero(ptr,len);
#elif defined WIN32 && GM_KERNEL
  RtlZeroMemory (ptr, len);
#elif defined WIN32 && !GM_KERNEL
  ZeroMemory (ptr, len);
#elif GM_OS_FREEBSD && GM_KERNEL
  bzero (ptr, len);
#elif defined STDC_HEADERS
#if GM_CPU_powerpc && !GM_KERNEL
  /* on powerpc, we do not want the optimized memset, which is using a
     special instruction incompatible with IO mapped memory */
#warning choosing a slow bzero, but memset that not work with IO-mapped memory
  gm_safer_bzero (ptr, len);
#else /* !powerpc special case */
  memset (ptr, 0, len);
#endif /* powerpc special case */
#elif defined HAVE_STRINGS_H
  bzero (ptr, len);
#else
#  error Do not know how to bzero
#endif
}
