/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_cmp64.h"
#include "gm_debug.h"
#include "gm_internal.h"

GM_ENTRY_POINT
gm_recv_event_t *
gm_blocking_receive_no_spin (gm_port_t * p)
{
  gm_recv_event_t *ret;

  GM_CALLED_WITH_ARGS (("%p", p));

  ret = gm_receive (p);
  if (gm_ntoh_u8 (ret->recv.type) != GM_NO_RECV_EVENT)
    {
      GM_RETURN_PTR (ret);
    }
  _gm_request_sleep (p);	/* spins until a recv event is pending */
  ret = gm_receive (p);
  GM_RETURN_PTR (ret);
}
