/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_internal.h"

#if !GM_KERNEL
#ifdef STDC_HEADERS
# include <string.h>
#elif defined HAVE_STRINGS_H
# include <strings.h>
#endif
#endif


#ifdef CSPI_MAP26xx
/* bcopy for when you can only access 4-byte chunks */
void CK_bcopy(char *src, char *dest, int length);
#endif /* CSPI_MAP26xx */

GM_ENTRY_POINT
void
gm_bcopy (void *from, void *to, gm_size_t len)
{
  if (len==0)
    return;
#if defined (CSPI_MAP26xx)
  CK_bcopy (from, to, len);
#elif GM_OS_VXWORKS || GM_OS_SOLARIS
  bcopy (from, to, len);
#elif GM_OS_LINUX 
  /* feldy made this change because newer linux get modversion symbole problems with memcpy/bcopy */
  {
    unsigned long i;
    unsigned char *to_c=(unsigned char *)to, *from_c=(unsigned char *)from;
    for (i=len; i ; i--) 
      {
         *to_c++ = *from_c++;
      }
  }
/*
  memcpy (to, from, len);
*/
#elif (defined WIN32 && GM_KERNEL)
  RtlCopyMemory (to, from, len);
#elif (defined WIN32 && !GM_KERNEL)
  CopyMemory (to, from, len);
#elif defined STDC_HEADERS
  memcpy (to, from, len);
#elif defined HAVE_STRINGS_H
  bcopy (from, to, len);
#else
#  error Do not know how to bcopy.
#endif
}


#ifdef CSPI_MAP26xx
/* bcopy for when you can only access 4-byte chunks */

void
CK_bcopy(char *src, char *dest, int length)
{
    register unsigned long ltmp_in, ltmp_out;
    register unsigned long mask_in, mask_out;
    register long shft_in, shft_out;
    register unsigned char btmp;
    register int i;

    for (i = 0; i < length; i++, src++, dest++) {

        /* calculate shifts and masks (remember: big-endian!) */
        shft_in = 8 * (3 - ((int) src & 0x3));
        mask_in = (0xff << shft_in);
        shft_out = 8 * (3 - ((int) dest & 0x3));
        mask_out = (0xff << shft_out);

        /* read in source word and obtain the byte */
        ltmp_in = *(long *) ((int) src & ~0x3);
        btmp = (ltmp_in & mask_in) >> shft_in;

        /* load byte into dest word */
        ltmp_out = *(long *) ((int) dest & ~0x3) & ~mask_out;
        ltmp_out |= (btmp << shft_out);

        /* store dest word */
        *(long *) ((int) dest & ~0x3) = ltmp_out;
    }
}
#endif /* CSPI_MAP26xx */

