/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: glenn@myri.com */

#include "gm_internal.h"

GM_ENTRY_POINT gm_status_t
gm_allow_remote_memory_access (struct gm_port *port)
{
  int i;
  unsigned pr;			/* priority */

  /* Pass some directed receive tokens of each priority to the LANai,
     enabling remote directed sends to write to memory registered to
     this port. */

  for (pr = GM_LOW_PRIORITY; pr <= GM_HIGH_PRIORITY; pr++)
    for (i = GM_NUM_DIRECTED_RECV_TOKENS / 2; i; i--)
      gm_provide_receive_buffer (port, (void *) 1, GM_DIRECTED_TAG_SIZE, pr);

  return GM_SUCCESS;
}

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
