/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#define _GM_DEBUG_SLEEP 0

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_internal.h"

#if _GM_DEBUG_SLEEP
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

/* If no such request is pending already, ask that the LANai
   atomically generate a GM_SLEEP recv event, and generate an
   interrupt the next time it a recv event is generated.  Block until
   any recv event.

   This function should be called only by gm_blocking_receive. */
gm_status_t
_gm_sleep (gm_port_t *p)
{
  GM_CALLED_WITH_ARGS (("%p", p));
#if GM_KERNEL
#  ifdef WIN32
  GM_RETURN_STATUS (GM_FAILURE);
#  else
  GM_RETURN_STATUS (gm_kernel_sleep (p->kernel_port_state));
#  endif
#else
  GM_RETURN_STATUS (_gm_user_ioctl (p, GM_SLEEP, 0, 0));
#endif
}

/*
  This file uses GM standard indentation.

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  End:
*/
