/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 			 *
 * Copyright (c) 1999 by Myricom, Inc.					 				 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

#include "gm_internal.h"

#error not yet implemented

GM_ENTRY_POINT
gm_status_t
_gm_set_opener_string(gm_port_t * p, gm_u8_t *opener_string)
{
#if GM_KERNEL
    int len,i;
	gm_port_state_t *ps = p->kernel_port_state;
	gm_instance_state_t *is = ps->instance;

	GM_PRINT (GM_PRINT_LEVEL >= 8,
			  ("_gm_set_opener_string (port=%p, '%s')\n", p, opener_string));

	for (i=0; i<GM_OPENER_STRING_MAX_LEN; i++) {
		ps->opener_string[i] = opener_string[i];
    }
	ps->opener_string[GM_OPENER_STRING_MAX_LEN-1] = 0;

	return GM_SUCCESS;
#else

	return _gm_user_ioctl(p, GM_SET_OPENER_PID, opener_string,
						  GM_OPENER_STRING_MAX_LEN);
#endif
}


/*
  This file uses feldy indentation:

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
