/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_enable_galvantech_workaround.h"
#include "gm_internal.h"
#include "gm_send_queue.h"

#define GM_DEBUG_RAW_SEND 0

/* Send raw data out the interface. */
GM_ENTRY_POINT
void
_gm_raw_send_with_callback (gm_port_t *p, void *data, unsigned int len,
			    unsigned int route_len,
			    gm_send_completion_callback_t callback,
			    void *context)
{
#if GM_ENABLE_GALVANTECH_WORKAROUND
  gm_u8_t *skipped_route;
  unsigned int skipped_len;
#endif
  
  GM_PRINT (GM_DEBUG_RAW_SEND,
	    ("_gm_raw_send_with_callback (%p, %p, %d, %d, %p, %p) called.\n",
	     p, data, len, route_len, callback, context));
  
  gm_assert (p);
  gm_assert (data);
  gm_assert (len);
  
  GM_SIMULATE_SIMULATE ( );

#if GM_DEBUG_BUFFERS
  {
    struct gm_buf_handle *bh = gm_find_buf (data);
    if (!bh) {
      fprintf (stderr, "gm_raw_send: got unregistered buffer %p\n", data);
      abort();
    }
    if (bh->status != gm_in_app) {
      fprintf (stderr, "gm_raw_send: buffer %p should have status %s not %s\n",
	       data,
	       gm_get_buf_status_name (gm_in_app),
	       gm_get_buf_status_name (bh->status));
      abort();
    }
    bh->status = gm_in_send;
  }
#endif /* GM_DEBUG_BUFFERS */

#if GM_ENABLE_GALVANTECH_WORKAROUND
  skipped_route = (gm_u8_t *)data;
  skipped_len = len;
  while (skipped_len && (*skipped_route & 0xc0) == 0x80)
    {
      skipped_route++;
      skipped_len--;
    }
#endif

  /* Pass send token to LANai.  Care must be taken to flush the message to
     memory before flushing the token, and the token should be flushed to
     memory immediately. */

  {
    struct gm_raw_send_send_event volatile *se;
    struct gm_raw_send_send_event batch_write;

    se = GM_SEND_QUEUE_SLOT (p, callback, context, raw_send);
    
    if (GM_STRUCT_WRITE_COMBINING)
      {
#if GM_ENABLE_GALVANTECH_WORKAROUND
	batch_write.ip_checksum
	  = gm_htons (_gm_ip_checksum (skipped_route, skipped_len));
#endif
	batch_write.message = gm_hton_up ((gm_up_t) data);
	batch_write.total_length = gm_hton_u32 (len);
	batch_write.route_length = gm_hton_u32 (route_len);
	batch_write.cleared = gm_hton_u16 (0);
	batch_write.reserved_after_cleared = gm_hton_u8 (0);
	batch_write.type = gm_hton_u8 (GM_RAW_SEND_EVENT);
	/* the code to compute the destination address looks a bit hackish, but we are in low-level code :-) */
	GM_COPY_TO_IO_SPACE (*se, batch_write);
      }
    else
      {
#if GM_ENABLE_GALVANTECH_WORKAROUND
	se->ip_checksum
	  = gm_htons (_gm_ip_checksum (skipped_route, skipped_len));
#endif
	se->message = gm_hton_up ((gm_up_t) data);
	se->total_length = gm_hton_u32 (len);
	se->route_length = gm_hton_u32 (route_len);
	se->cleared = gm_hton_u16 (0);
	se->reserved_after_cleared = gm_hton_u8 (0);
	GM_STBAR ();
	se->type = gm_hton_u8 (GM_RAW_SEND_EVENT);
      }
    GM_FLUSH_SEND_EVENT (p, se);
  }
}

GM_ENTRY_POINT
void
_gm_raw_send (struct gm_port *p, void *data, unsigned int len, unsigned int route_len)
{
  _gm_raw_send_with_callback (p, data, len, route_len, _gm_sent, data);
}
