/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_debug.h"
#include "gm_enable_ethernet.h"
#include "gm_internal.h"
#include "gm_pio.h"
#include "gm_send_queue.h"

#define GM_DEBUG_PROVIDE_ETHERNET_SCATTER_LIST 0

#if GM_KERNEL
void
_gm_provide_ethernet_scatter_list (gm_port_t * p,
				   gm_u32_t segment_cnt,
				   gm_ethernet_segment_descriptor_t segment[])
{
#if GM_ENABLE_ETHERNET
  volatile gm_ethernet_recv_token_t *ert;
    
  
  ert = p->ethernet.recv_token_queue_slot;

  /* preconditions */

  gm_assert (ert);
  GM_PRINT
    (GM_DEBUG_PROVIDE_ETHERNET_SCATTER_LIST,
     ("gm_provide_ethernet_scatter_list(*,%d,%d)[0x%x,0x%x,...] (g23754)\n", 
      segment_cnt,
      ert-p->ethernet.recv_token_queue_start,
      gm_ntoh_u32 (segment[0].len),
      (segment_cnt > 1
       ? gm_ntoh_u32 (segment[1].len)
       : 0)));
  
  /* Copy the scatter list, writing ert->segment[0].len last. */
  
  gm_assert (segment_cnt);
  gm_assert (segment_cnt < GM_MAX_ETHERNET_SCATTER_CNT);
  gm_assert (p->ethernet.recv_token_queue_limit
	       == &(p->ethernet.recv_token_queue_start
		    [GM_NUM_ETHERNET_RECV_TOKENS]));
  gm_assert (GM_DMA_ALIGNED (gm_ntoh_dp (segment[0].ptr)));
  gm_assert (GM_DMA_ALIGNED (gm_ntoh_u32 (segment[0].len)));
  gm_assert (gm_ntoh_dp (segment[0].ptr));
  gm_assert (gm_ntoh_u32 (segment[0].len));
  if (GM_DEBUG)
    {
      unsigned l;

      /* loic: this can be replaced by a simple assertion, I used the code
         to identify a potential hardware problem on lx */

      if ((l = gm_ntoh_u32 (ert->segment[0].len)) != 0)
	{
	  gm_write_lanai_special_reg_u32 (p->kernel_port_state->instance,
					  l4.LED, 0x55555555);
	  
	  GM_PRINT (1, (__GM_FUNCTION__
			":ert->segment[0].len!=0, ert=%p,"
			" ert->segment[0].len=0x%x, reload=0x%x\n",
			ert, l, gm_ntoh_u32 (ert->segment[0].len)));
	}
    }

  GM_PRINT (GM_PRINT_LEVEL >= 5,
	    ("gm_provide_ethernet_scatter_list(*,%d,%d)[0x%x,0x%x,...]\n",
	     segment_cnt,
	     ert - p->ethernet.recv_token_queue_start,
	     gm_ntoh_u32 (segment[0].len),
	     segment_cnt > 1 ? gm_ntoh_u32 (segment[1].len) : 0));

  /* Copy the scatter list, writing ert->segment[0].len last. */

  if (segment_cnt < GM_MAX_ETHERNET_SCATTER_CNT)
    {
      ert->segment[segment_cnt].ptr = gm_hton_dp (0);
      ert->segment[segment_cnt].len = gm_hton_u32 (0);
      gm_assert (gm_ntoh_u32 (ert->segment[segment_cnt].len) == 0);
    }
  while (--segment_cnt)
  {
    gm_assert (GM_DMA_ALIGNED (gm_ntoh_dp (segment[segment_cnt].ptr)));
    gm_assert (GM_DMA_ALIGNED (gm_ntoh_u32 (segment[segment_cnt].len)));
    gm_assert (gm_ntoh_dp (segment[segment_cnt].ptr));
    gm_assert (gm_ntoh_u32 (segment[segment_cnt].len));
    ert->segment[segment_cnt].ptr = segment[segment_cnt].ptr;
    ert->segment[segment_cnt].len = segment[segment_cnt].len;
  }

  gm_assert (GM_DMA_ALIGNED (gm_ntoh_dp (segment[0].ptr)));
  gm_assert (GM_DMA_ALIGNED (gm_ntoh_u32 (segment[0].len)));
  gm_assert (gm_ntoh_dp (segment[0].ptr));
  gm_assert (gm_ntoh_u32 (segment[0].len));
  
  if (GM_STRUCT_WRITE_COMBINING)
    {
      GM_COPY_TO_IO_SPACE (ert->segment[0], segment[0]);
    }
  else
    {
      ert->segment[0].ptr = segment[0].ptr;
      GM_STBAR ();
      ert->segment[0].len = segment[0].len;
    }

  GM_STBAR ();
  GM_READBACK_TO_FLUSH_WRITES (p, ert);

  p->ethernet.recv_token_queue_slot = (gm_ethernet_recv_token_t *) (ert + 1);
  if (p->ethernet.recv_token_queue_slot >= p->ethernet.recv_token_queue_limit)
    {
      GM_PRINT (GM_PRINT_LEVEL >= 7, ("wrapping recv token queue (g23754).\n"));
      p->ethernet.recv_token_queue_slot = p->ethernet.recv_token_queue_start;
    }
#endif /* GM_ENABLE_ETHERNET */
}
#endif /* GM_KERNEL */
