/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include "gm_call_trace.h"
#include "gm_debug.h"
#include "gm_internal.h"

#define GM_DEBUG__MMAP 0

#if GM_DEBUG__MMAP
#undef GM_LOCALLY_ENABLE_CALL_TRACE
#define GM_LOCALLY_ENABLE_CALL_TRACE 1
#endif

				/* mmap(), munmap() */
#if !GM_KERNEL
#  ifdef STDC_HEADERS
#    include <stdio.h>		/* for perror() */
#  endif
#  ifdef HAVE_SYS_TYPES_H
#    include <sys/types.h>
#  endif
#  ifdef HAVE_SYS_MMAN_H
#    include <sys/mman.h>
#  endif
#  ifdef HAVE_ERRNO_H
#    include <errno.h>
#  endif
#endif

#if !GM_KERNEL && !GM_OS_VXWORKS && !_WIN32
/* just used to make sure a variable is actually read */
static void gm_touch_int(int it)
{
  if (it==0)
    {
    }
  else 
    {
    }
}
#endif

#if !GM_KERNEL

/* Do the OS-specific user-level part of _gm_mmap(), but
   do not call _gm_finish_mmap(). */

static
gm_status_t
_gm_user_mmap (gm_port_t *p, gm_offset_t offset, gm_size_t len, int flags,
	       void **result)
{
  gm_status_t status;
  
  GM_CALLED ();

  gm_assert (!GM_OS_VXWORKS);	/* because !GM_KERNEL */
  
#if defined _WIN32
  {
    gm_mmap_info_t i;

    i.offset = GM_STATIC_CAST (gm_u32_t, offset);
    i.len = GM_STATIC_CAST (gm_u32_t, len);
    i.va = (void *) -1;
    i.requested_permissions = flags;
    status = _gm_user_ioctl (p, GM_MMAP, &i, sizeof(i));
    if (status != GM_SUCCESS)
      goto abort_with_nothing;
    if (i.va == (void *)-1)
      goto abort_with_nothing;
    *result = i.va;
  }
#else  /* default OS */
  {
    GM_PRINT
      (GM_DEBUG__MMAP,
       ("_gm_mmap called len = 0x%lx  offset = 0x%lx\n", len, offset));
    *result = mmap (0, len, flags, MAP_SHARED, p->fd, offset);
    if (*result == (void *) -1 || *result == 0)
      {
	perror("_gm_mmap: mmap failed");
	GM_PRINT (GM_DEBUG__MMAP, ("_gm_mmap mmap failed\n"));
	status = GM_FAILURE;
	goto abort_with_nothing;
      }

    /* DU doesn't call driver mmap until pointer is dereferenced */
    /* DU should we actually touch all the pages - feldy?        */
    gm_touch_int(*(int *)(*result));
  }
#endif

  GM_RETURN_STATUS (GM_SUCCESS);
  
 abort_with_nothing:
  GM_RETURN_STATUS (status);
}
#endif /* !GM_KERNEL */

gm_status_t
_gm_mmap (gm_port_t *p, gm_offset_t offset, gm_size_t len, int flags,
	  void **result)
{
  GM_CALLED ();
  
#if GM_KERNEL
  {
    gm_status_t status;
  
    if (!len)
      return GM_INVALID_PARAMETER;
  
    /* allocate any needed resources */

    status = gm_prepare_to_mmap (p->kernel_port_state, offset, len, flags);
    if (status != GM_SUCCESS)
      {
	goto abort_with_nothing;
      }
    
    /* get a pointer to the resource */
    status = gm_mmap (p->kernel_port_state, offset, result);
    if (status != GM_SUCCESS)
      {
	goto abort_with_preparations;
      }

    /* Tell the driver where the resource was mapped */

    status = _gm_finish_mmap (p, offset, len, (gm_up_t) *result);
    if (status != GM_SUCCESS)
      {
	GM_PRINT
	  (GM_DEBUG__MMAP, ("_gm_finish_mmap() failed %p\n", result));
	goto abort_with_addr;
      }

    gm_assert (*result != (void *) 0);
    gm_assert (*result != (void *) -1);
 
    GM_RETURN_STATUS (GM_SUCCESS);

  abort_with_addr:
  abort_with_preparations:
  abort_with_nothing:
    *result = (void *) 0;
    GM_RETURN_STATUS (status);
  }
#else  /* !GM_KERNEL */
  {
    gm_status_t status;
  
    status = _gm_user_mmap (p, offset, len, flags, result);
    if (status != GM_SUCCESS)
      {
	goto abort_with_nothing;
      }
    
    /* Tell the driver where the resource was mapped */

    status = _gm_finish_mmap (p, offset, len, (gm_up_t) *result);
    if (status != GM_SUCCESS)
      {
	GM_PRINT
	  (GM_DEBUG__MMAP, ("_gm_finish_mmap() failed %p\n", result));
	goto abort_with_mmap;
      }
  
    GM_PRINT (GM_DEBUG__MMAP, ("_gm_mmap: mmap returns %p\n", *result));

    gm_assert (*result != (void *)0);
    gm_assert (*result != (void *)-1);
    GM_RETURN_STATUS (GM_SUCCESS);
  
  abort_with_mmap:
    _gm_munmap (p, *result, GM_STATIC_CAST (unsigned long, len));
  abort_with_nothing:
    *result = (void *)0;
    GM_RETURN_STATUS (status);
  }
#endif /* GM_KERNEL */
}
